/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.CodeInsightTestCase;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.quickFix.LightQuickFixTestCase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.lang.ExternalAnnotatorsFilter;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFileNSInfoProvider;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.HighlightTestInfo;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.XmlSchemaProvider;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;

public abstract class DaemonAnalyzerTestCase
extends CodeInsightTestCase {
    private final Map<String, InspectionToolWrapper> myAvailableTools = new THashMap();
    private final FileTreeAccessFilter myFileTreeAccessFilter = new FileTreeAccessFilter();

    protected boolean isRunInWriteAction() {
        return false;
    }

    @Override
    protected void setUp() throws Exception {
        LocalInspectionTool[] tools;
        super.setUp();
        for (LocalInspectionTool tool : tools = this.configureLocalInspectionTools()) {
            this.enableInspectionTool(tool);
        }
        InspectionProfileImpl profile = new InspectionProfileImpl("Configurable"){

            public ModifiableModel getModifiableModel() {
                this.mySource = this;
                return this;
            }

            public InspectionToolWrapper[] getInspectionTools(PsiElement element) {
                Collection values = DaemonAnalyzerTestCase.this.myAvailableTools.values();
                return values.toArray(new InspectionToolWrapper[values.size()]);
            }

            public List<Tools> getAllEnabledInspectionTools(Project project) {
                ArrayList<Tools> result = new ArrayList<Tools>();
                for (InspectionToolWrapper toolWrapper : this.getInspectionTools(null)) {
                    result.add((Tools)new ToolsImpl(toolWrapper, toolWrapper.getDefaultLevel(), true));
                }
                return result;
            }

            public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element) {
                return key != null && DaemonAnalyzerTestCase.this.myAvailableTools.containsKey(key.toString());
            }

            public HighlightDisplayLevel getErrorLevel(HighlightDisplayKey key, PsiElement element) {
                InspectionToolWrapper localInspectionTool = (InspectionToolWrapper)DaemonAnalyzerTestCase.this.myAvailableTools.get(key.toString());
                return localInspectionTool != null ? localInspectionTool.getDefaultLevel() : HighlightDisplayLevel.WARNING;
            }

            public InspectionToolWrapper getInspectionTool(String shortName, PsiElement element) {
                return (InspectionToolWrapper)DaemonAnalyzerTestCase.this.myAvailableTools.get(shortName);
            }
        };
        final InspectionProfileManager inspectionProfileManager = InspectionProfileManager.getInstance();
        inspectionProfileManager.addProfile((Profile)profile);
        inspectionProfileManager.setRootProfile("Configurable");
        Disposer.register((Disposable)this.getProject(), (Disposable)new Disposable(){

            public void dispose() {
                inspectionProfileManager.deleteProfile("Configurable");
            }
        });
        InspectionProjectProfileManager.getInstance((Project)this.getProject()).updateProfile((Profile)profile);
        InspectionProjectProfileManager.getInstance((Project)this.getProject()).setProjectProfile(profile.getName());
        DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(this.getProject());
        daemonCodeAnalyzer.prepareForTest();
        StartupManagerImpl startupManager = (StartupManagerImpl)StartupManagerEx.getInstanceEx((Project)this.getProject());
        startupManager.runStartupActivities();
        startupManager.startCacheUpdate();
        startupManager.runPostStartupActivities();
        DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
        if (this.isPerformanceTest()) {
            IntentionManager.getInstance().getAvailableIntentionActions();
            PathManagerEx.getTestDataPath();
            ReferenceProvidersRegistry.getInstance();
            InjectedLanguageManager.getInstance(this.getProject());
            LanguageAnnotators.INSTANCE.allForLanguage(JavaLanguage.INSTANCE);
            LanguageAnnotators.INSTANCE.allForLanguage(StdLanguages.XML);
            ProblemHighlightFilter.EP_NAME.getExtensions();
            Extensions.getExtensions(ImplicitUsageProvider.EP_NAME);
            Extensions.getExtensions(XmlSchemaProvider.EP_NAME);
            Extensions.getExtensions(XmlFileNSInfoProvider.EP_NAME);
            Extensions.getExtensions(ExternalAnnotatorsFilter.EXTENSION_POINT_NAME);
            Extensions.getExtensions((ExtensionPointName)IndexPatternBuilder.EP_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            Project project = this.getProject();
            if (project != null) {
                ((StartupManagerImpl)StartupManager.getInstance(project)).checkCleared();
                ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance(project)).cleanupAfterTest();
            }
        }
        finally {
            super.tearDown();
        }
    }

    protected void enableInspectionTool(InspectionProfileEntry tool) {
        InspectionToolWrapper toolWrapper = InspectionToolRegistrar.wrapTool((InspectionProfileEntry)tool);
        LightPlatformTestCase.enableInspectionTool(this.myAvailableTools, (InspectionToolWrapper)toolWrapper);
    }

    protected void enableInspectionToolsFromProvider(InspectionToolProvider toolProvider) {
        try {
            for (Class c : toolProvider.getInspectionClasses()) {
                this.enableInspectionTool((LocalInspectionTool)c.newInstance());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void disableInspectionTool(String shortName) {
        this.myAvailableTools.remove(shortName);
    }

    protected LocalInspectionTool[] configureLocalInspectionTools() {
        return LocalInspectionTool.EMPTY_ARRAY;
    }

    protected static LocalInspectionTool[] createLocalInspectionTools(InspectionToolProvider ... provider) {
        ArrayList<LocalInspectionTool> result = new ArrayList<LocalInspectionTool>();
        for (InspectionToolProvider toolProvider : provider) {
            for (Class aClass : toolProvider.getInspectionClasses()) {
                try {
                    Object tool = aClass.newInstance();
                    DaemonAnalyzerTestCase.assertTrue((boolean)(tool instanceof LocalInspectionTool));
                    result.add((LocalInspectionTool)tool);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        return result.toArray(new LocalInspectionTool[result.size()]);
    }

    protected void doTest(@NonNls String filePath, boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) throws Exception {
        this.configureByFile(filePath);
        this.doDoTest(checkWarnings, checkInfos, checkWeakWarnings);
    }

    protected void doTest(@NonNls String filePath, boolean checkWarnings, boolean checkInfos) throws Exception {
        this.doTest(filePath, checkWarnings, checkInfos, false);
    }

    protected void doTest(@NonNls String filePath, @NonNls String projectRoot, boolean checkWarnings, boolean checkInfos) throws Exception {
        this.configureByFile(filePath, projectRoot);
        this.doDoTest(checkWarnings, checkInfos);
    }

    protected HighlightTestInfo testFile(String ... filePath) {
        return new HighlightTestInfo(this.getTestRootDisposable(), filePath){

            public HighlightTestInfo doTest() {
                try {
                    DaemonAnalyzerTestCase.this.configureByFiles(this.projectRoot, this.filePaths);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                ExpectedHighlightingData data = new ExpectedHighlightingData(DaemonAnalyzerTestCase.this.myEditor.getDocument(), this.checkWarnings, this.checkWeakWarnings, this.checkInfos, DaemonAnalyzerTestCase.this.myFile);
                if (this.checkSymbolNames) {
                    data.checkSymbolNames();
                }
                DaemonAnalyzerTestCase.this.checkHighlighting(data);
                return this;
            }
        };
    }

    protected void doTest(VirtualFile vFile, boolean checkWarnings, boolean checkInfos) throws Exception {
        this.doTest(new VirtualFile[]{vFile}, checkWarnings, checkInfos);
    }

    protected void doTest(VirtualFile[] vFile, boolean checkWarnings, boolean checkInfos) throws Exception {
        this.configureByFiles(null, vFile);
        this.doDoTest(checkWarnings, checkInfos);
    }

    protected void doTest(boolean checkWarnings, boolean checkInfos, String ... files) throws Exception {
        this.configureByFiles(null, files);
        this.doDoTest(checkWarnings, checkInfos);
    }

    protected Collection<HighlightInfo> doDoTest(boolean checkWarnings, boolean checkInfos) {
        return this.doDoTest(checkWarnings, checkInfos, false);
    }

    protected Collection<HighlightInfo> doDoTest(final boolean checkWarnings, final boolean checkInfos, final boolean checkWeakWarnings) {
        return ContainerUtil.filter(this.checkHighlighting(new ExpectedHighlightingData(this.myEditor.getDocument(), checkWarnings, checkWeakWarnings, checkInfos, this.myFile)), (Condition)new Condition<HighlightInfo>(){

            public boolean value(HighlightInfo info) {
                return info.getSeverity() == HighlightSeverity.INFORMATION && checkInfos || info.getSeverity() == HighlightSeverity.WARNING && checkWarnings || info.getSeverity() == HighlightSeverity.WEAK_WARNING && checkWeakWarnings || info.getSeverity().compareTo(HighlightSeverity.WARNING) > 0;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<HighlightInfo> checkHighlighting(ExpectedHighlightingData data) {
        JavaPsiFacadeEx facade;
        data.init();
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                TreeUtil.clearCaches((TreeElement)((TreeElement)DaemonAnalyzerTestCase.this.myFile.getNode()));
            }
        });
        if (!DumbService.isDumb(this.getProject())) {
            CacheManager.SERVICE.getInstance((Project)this.myProject).getFilesWithWord("XXX", (short)2, GlobalSearchScope.allScope(this.myProject), true);
        }
        if ((facade = this.getJavaFacade()) != null) {
            facade.setAssertOnFileLoadingFilter((VirtualFileFilter)this.myFileTreeAccessFilter, this.myTestRootDisposable);
        }
        try {
            List<HighlightInfo> infos = this.doHighlighting();
            String text = this.myEditor.getDocument().getText();
            data.checkLineMarkers((Collection)DaemonCodeAnalyzerImpl.getLineMarkers((Document)this.getDocument(this.getFile()), (Project)this.getProject()), text);
            data.checkResult(infos, text);
            List<HighlightInfo> list = infos;
            return list;
        }
        finally {
            if (facade != null) {
                facade.setAssertOnFileLoadingFilter(VirtualFileFilter.NONE, this.myTestRootDisposable);
            }
        }
    }

    protected void allowTreeAccessForFile(VirtualFile file) {
        this.myFileTreeAccessFilter.allowTreeAccessForFile(file);
    }

    protected void allowTreeAccessForAllFiles() {
        this.myFileTreeAccessFilter.allowTreeAccessForAllFiles();
    }

    protected List<HighlightInfo> highlightErrors() {
        return this.doHighlighting(HighlightSeverity.ERROR);
    }

    protected List<HighlightInfo> doHighlighting(HighlightSeverity minSeverity) {
        return DaemonAnalyzerTestCase.filter(this.doHighlighting(), minSeverity);
    }

    protected List<HighlightInfo> doHighlighting() {
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
        TIntArrayList toIgnore = new TIntArrayList();
        if (!this.doTestLineMarkers()) {
            toIgnore.add(6);
            toIgnore.add(10);
            toIgnore.add(11);
        }
        if (!this.doExternalValidation()) {
            toIgnore.add(8);
        }
        if (this.forceExternalValidation()) {
            toIgnore.add(11);
            toIgnore.add(7);
            toIgnore.add(12);
            toIgnore.add(3);
            toIgnore.add(4);
            toIgnore.add(6);
            toIgnore.add(10);
        }
        boolean canChange = this.canChangeDocumentDuringHighlighting();
        List infos = CodeInsightTestFixtureImpl.instantiateAndRun((PsiFile)this.getFile(), (Editor)this.getEditor(), (int[])toIgnore.toNativeArray(), (boolean)canChange);
        if (!canChange) {
            Document document = this.getDocument(this.getFile());
            DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx((Project)this.myProject);
            daemonCodeAnalyzer.getFileStatusMap().assertAllDirtyScopesAreNull(document);
        }
        return infos;
    }

    private boolean canChangeDocumentDuringHighlighting() {
        return this.annotatedWith(CanChangeDocumentDuringHighlighting.class);
    }

    protected static List<HighlightInfo> filter(List<HighlightInfo> infos, HighlightSeverity minSeverity) {
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>();
        for (HighlightInfo info : infos) {
            if (info.getSeverity().compareTo(minSeverity) < 0) continue;
            result.add(info);
        }
        return result;
    }

    protected boolean doTestLineMarkers() {
        return false;
    }

    protected boolean doExternalValidation() {
        return true;
    }

    protected boolean forceExternalValidation() {
        return false;
    }

    protected static void findAndInvokeIntentionAction(Collection<HighlightInfo> infos, String intentionActionName, Editor editor, PsiFile file) throws IncorrectOperationException {
        IntentionAction intentionAction = DaemonAnalyzerTestCase.findIntentionAction(infos, intentionActionName, editor, file);
        DaemonAnalyzerTestCase.assertNotNull((String)intentionActionName, (Object)intentionAction);
        DaemonAnalyzerTestCase.assertTrue((boolean)ShowIntentionActionsHandler.chooseActionAndInvoke((PsiFile)file, (Editor)editor, (IntentionAction)intentionAction, (String)intentionActionName));
        UIUtil.dispatchAllInvocationEvents();
    }

    protected static IntentionAction findIntentionAction(Collection<HighlightInfo> infos, String intentionActionName, Editor editor, PsiFile file) {
        List<IntentionAction> actions = LightQuickFixTestCase.getAvailableActions(editor, file);
        IntentionAction intentionAction = LightQuickFixTestCase.findActionWithText(actions, intentionActionName);
        if (intentionAction == null) {
            ArrayList<IntentionAction> availableActions = new ArrayList<IntentionAction>();
            for (HighlightInfo info : infos) {
                if (info.quickFixActionRanges == null) continue;
                for (Pair pair : info.quickFixActionRanges) {
                    IntentionAction action = ((HighlightInfo.IntentionActionDescriptor)pair.first).getAction();
                    if (!action.isAvailable(file.getProject(), editor, file)) continue;
                    availableActions.add(action);
                }
            }
            intentionAction = LightQuickFixTestCase.findActionWithText(availableActions, intentionActionName);
        }
        return intentionAction;
    }

    public void checkHighlighting(Editor editor, boolean checkWarnings, boolean checkInfos) {
        this.setActiveEditor(editor);
        this.doDoTest(checkWarnings, checkInfos);
    }

    public PsiClass createClass(String text) throws IOException {
        return this.createClass(this.myModule, text);
    }

    protected PsiClass createClass(final Module module, final String text) throws IOException {
        return (PsiClass)new WriteCommandAction<PsiClass>(this.getProject(), new PsiFile[0]){

            @Override
            protected void run(Result<PsiClass> result) throws Throwable {
                File dir;
                PsiFileFactory factory = PsiFileFactory.getInstance(this.getProject());
                PsiJavaFile javaFile = (PsiJavaFile)factory.createFileFromText("a.java", (FileType)JavaFileType.INSTANCE, (CharSequence)text);
                String qname = javaFile.getClasses()[0].getQualifiedName();
                TestCase.assertNotNull((Object)qname);
                VirtualFile[] files = ModuleRootManager.getInstance(module).getSourceRoots();
                if (files.length > 0) {
                    dir = VfsUtilCore.virtualToIoFile(files[0]);
                } else {
                    dir = DaemonAnalyzerTestCase.this.createTempDirectory();
                    VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(dir.getCanonicalPath().replace(File.separatorChar, '/'));
                    DaemonAnalyzerTestCase.this.addSourceContentToRoots(module, vDir);
                }
                File file = new File(dir, qname.replace('.', '/') + ".java");
                FileUtil.createIfDoesntExist((File)file);
                VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(file.getCanonicalPath().replace(File.separatorChar, '/'));
                TestCase.assertNotNull((Object)vFile);
                VfsUtil.saveText(vFile, text);
                PsiJavaFile psiFile = (PsiJavaFile)DaemonAnalyzerTestCase.this.myPsiManager.findFile(vFile);
                TestCase.assertNotNull((Object)psiFile);
                PsiClass psiClass = psiFile.getClasses()[0];
                result.setResult(psiClass);
            }
        }.execute().throwException().getResultObject();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface CanChangeDocumentDuringHighlighting {
    }
}

