/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class HighlightDisplayKey {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.HighlightDisplayKey");
    private static final Map<String, HighlightDisplayKey> ourNameToKeyMap = new THashMap();
    private static final Map<String, HighlightDisplayKey> ourIdToKeyMap = new THashMap();
    private static final Map<HighlightDisplayKey, Computable<String>> ourKeyToDisplayNameMap = new THashMap();
    private static final Map<HighlightDisplayKey, String> ourKeyToAlternativeIDMap = new THashMap();
    private final String myName;
    private final String myID;

    public static HighlightDisplayKey find(@NonNls String name) {
        return ourNameToKeyMap.get(name);
    }

    public static HighlightDisplayKey findById(@NonNls String id) {
        HighlightDisplayKey key = ourIdToKeyMap.get(id);
        if (key != null) {
            return key;
        }
        key = ourNameToKeyMap.get(id);
        if (key != null && key.getID().equals(id)) {
            return key;
        }
        return null;
    }

    public static HighlightDisplayKey register(@NonNls String name) {
        if (HighlightDisplayKey.find(name) != null) {
            LOG.info("Key with name '" + name + "' already registered");
            return null;
        }
        return new HighlightDisplayKey(name);
    }

    public static HighlightDisplayKey register(@NonNls String name, String displayName) {
        return HighlightDisplayKey.register(name, displayName, name);
    }

    public static HighlightDisplayKey register(@NonNls String name, Computable<String> displayName) {
        return HighlightDisplayKey.register(name, displayName, name);
    }

    public static HighlightDisplayKey register(@NonNls String name, String displayName, @NonNls String id) {
        return HighlightDisplayKey.register(name, (Computable<String>)new Computable.PredefinedValueComputable((Object)displayName), id);
    }

    public static HighlightDisplayKey register(@NonNls String name, Computable<String> displayName, @NonNls String id) {
        if (HighlightDisplayKey.find(name) != null) {
            LOG.info("Key with name '" + name + "' already registered");
            return null;
        }
        HighlightDisplayKey highlightDisplayKey = new HighlightDisplayKey(name, id);
        ourKeyToDisplayNameMap.put(highlightDisplayKey, displayName);
        return highlightDisplayKey;
    }

    public static HighlightDisplayKey register(@NonNls String name, Computable<String> displayName, @NonNls String id, @NonNls String alternativeID) {
        HighlightDisplayKey key = HighlightDisplayKey.register(name, displayName, id);
        if (alternativeID != null) {
            ourKeyToAlternativeIDMap.put(key, alternativeID);
        }
        return key;
    }

    public static HighlightDisplayKey findOrRegister(@NonNls String name, String displayName) {
        return HighlightDisplayKey.findOrRegister(name, displayName, null);
    }

    public static HighlightDisplayKey findOrRegister(@NonNls String name, String displayName, @NonNls String id) {
        HighlightDisplayKey key = HighlightDisplayKey.find(name);
        if (key == null) {
            key = HighlightDisplayKey.register(name, displayName, id != null ? id : name);
            assert (key != null) : name;
        }
        return key;
    }

    public static String getDisplayNameByKey(HighlightDisplayKey key) {
        if (key == null) {
            return null;
        }
        Computable<String> computable = ourKeyToDisplayNameMap.get(key);
        return computable == null ? null : (String)computable.compute();
    }

    public static String getAlternativeID(HighlightDisplayKey key) {
        return ourKeyToAlternativeIDMap.get(key);
    }

    private HighlightDisplayKey(@NonNls String name) {
        this(name, name);
    }

    public HighlightDisplayKey(@NonNls String name, @NonNls String ID2) {
        this.myName = name;
        this.myID = ID2;
        ourNameToKeyMap.put(this.myName, this);
        if (!Comparing.equal((String)ID2, (String)name)) {
            ourIdToKeyMap.put(ID2, this);
        }
    }

    public String toString() {
        return this.myName;
    }

    public String getID() {
        return this.myID;
    }
}

