/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.Icon;

public class LineMarkerInfo<T extends PsiElement> {
    protected final Icon myIcon;
    private final WeakReference<T> elementRef;
    public final int startOffset;
    public final int endOffset;
    public Color separatorColor;
    public SeparatorPlacement separatorPlacement;
    public RangeHighlighter highlighter;
    public final int updatePass;
    private final Function<? super T, String> myTooltipProvider;
    private final GutterIconRenderer.Alignment myIconAlignment;
    private final GutterIconNavigationHandler<T> myNavigationHandler;

    public LineMarkerInfo(T element, int startOffset, Icon icon, int updatePass, Function<? super T, String> tooltipProvider, GutterIconNavigationHandler<T> navHandler, GutterIconRenderer.Alignment alignment) {
        this((T)element, new TextRange(startOffset, startOffset), icon, updatePass, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, alignment);
    }

    public LineMarkerInfo(T element, TextRange range, Icon icon, int updatePass, Function<? super T, String> tooltipProvider, GutterIconNavigationHandler<T> navHandler, GutterIconRenderer.Alignment alignment) {
        this.myIcon = icon;
        this.myTooltipProvider = tooltipProvider;
        this.myIconAlignment = alignment;
        this.elementRef = new WeakReference<T>(element);
        this.myNavigationHandler = navHandler;
        this.startOffset = range.getStartOffset();
        this.updatePass = updatePass;
        this.endOffset = range.getEndOffset();
    }

    public LineMarkerInfo(T element, int startOffset, Icon icon, int updatePass, Function<? super T, String> tooltipProvider, GutterIconNavigationHandler<T> navHandler) {
        this((T)element, startOffset, icon, updatePass, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, GutterIconRenderer.Alignment.RIGHT);
    }

    public GutterIconRenderer createGutterRenderer() {
        if (this.myIcon == null) {
            return null;
        }
        return new LineMarkerGutterIconRenderer(this);
    }

    public String getLineMarkerTooltip() {
        T element = this.getElement();
        if (element == null || !element.isValid()) {
            return null;
        }
        if (this.myTooltipProvider != null) {
            return (String)this.myTooltipProvider.fun(element);
        }
        return null;
    }

    public T getElement() {
        return (T)((PsiElement)this.elementRef.get());
    }

    public GutterIconNavigationHandler<T> getNavigationHandler() {
        return this.myNavigationHandler;
    }

    public String toString() {
        return "(" + this.startOffset + "," + this.endOffset + ") -> " + this.elementRef.get();
    }

    public static class LineMarkerGutterIconRenderer<T extends PsiElement>
    extends GutterIconRenderer {
        private final LineMarkerInfo<T> myInfo;

        public LineMarkerGutterIconRenderer(LineMarkerInfo<T> info) {
            this.myInfo = info;
        }

        public LineMarkerInfo<T> getLineMarkerInfo() {
            return this.myInfo;
        }

        @Override
        public Icon getIcon() {
            return this.myInfo.myIcon;
        }

        @Override
        public AnAction getClickAction() {
            LineMarkerInfo<T> lineMarkerInfo = this.myInfo;
            lineMarkerInfo.getClass();
            return lineMarkerInfo.new NavigateAction();
        }

        @Override
        public boolean isNavigateAction() {
            return ((LineMarkerInfo)this.myInfo).myNavigationHandler != null;
        }

        @Override
        public String getTooltipText() {
            try {
                return this.myInfo.getLineMarkerTooltip();
            }
            catch (IndexNotReadyException ignored) {
                return null;
            }
        }

        @Override
        public GutterIconRenderer.Alignment getAlignment() {
            return ((LineMarkerInfo)this.myInfo).myIconAlignment;
        }

        protected boolean looksTheSameAs(LineMarkerGutterIconRenderer renderer) {
            return this.myInfo.getElement() != null && renderer.myInfo.getElement() != null && this.myInfo.getElement() == renderer.myInfo.getElement() && Comparing.equal((Object)((LineMarkerInfo)this.myInfo).myTooltipProvider, (Object)((LineMarkerInfo)renderer.myInfo).myTooltipProvider) && Comparing.equal((Object)this.myInfo.myIcon, (Object)renderer.myInfo.myIcon);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof LineMarkerGutterIconRenderer && this.looksTheSameAs((LineMarkerGutterIconRenderer)obj);
        }

        @Override
        public int hashCode() {
            T element = this.myInfo.getElement();
            return element == null ? 0 : element.hashCode();
        }
    }

    private class NavigateAction
    extends AnAction {
        private NavigateAction() {
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            if (LineMarkerInfo.this.myNavigationHandler != null) {
                MouseEvent mouseEvent = (MouseEvent)e.getInputEvent();
                Object element = LineMarkerInfo.this.getElement();
                if (element == null || !element.isValid()) {
                    return;
                }
                LineMarkerInfo.this.myNavigationHandler.navigate(mouseEvent, element);
            }
        }
    }
}

