/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

public class RelatedItemLineMarkerInfo<T extends PsiElement>
extends MergeableLineMarkerInfo<T> {
    private final NotNullLazyValue<Collection<? extends GotoRelatedItem>> myTargets;

    public RelatedItemLineMarkerInfo(T element, TextRange range, Icon icon, int updatePass, Function<? super T, String> tooltipProvider, GutterIconNavigationHandler<T> navHandler, GutterIconRenderer.Alignment alignment, NotNullLazyValue<Collection<? extends GotoRelatedItem>> targets) {
        super(element, range, icon, updatePass, tooltipProvider, navHandler, alignment);
        this.myTargets = targets;
    }

    public RelatedItemLineMarkerInfo(T element, TextRange range, Icon icon, int updatePass, Function<? super T, String> tooltipProvider, GutterIconNavigationHandler<T> navHandler, GutterIconRenderer.Alignment alignment, final Collection<? extends GotoRelatedItem> targets) {
        this((T)element, range, icon, updatePass, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, alignment, (NotNullLazyValue<Collection<GotoRelatedItem>>)new NotNullLazyValue<Collection<? extends GotoRelatedItem>>(){

            protected Collection<? extends GotoRelatedItem> compute() {
                return targets;
            }
        });
    }

    public Collection<? extends GotoRelatedItem> createGotoRelatedItems() {
        return (Collection)this.myTargets.getValue();
    }

    @Override
    public GutterIconRenderer createGutterRenderer() {
        if (this.myIcon == null) {
            return null;
        }
        return new RelatedItemLineMarkerGutterIconRenderer(this);
    }

    @Override
    public boolean canMergeWith(MergeableLineMarkerInfo<?> info) {
        return this.myIcon == info.myIcon;
    }

    @Override
    public Icon getCommonIcon(List<MergeableLineMarkerInfo> infos) {
        return this.myIcon;
    }

    @Override
    public Function<? super PsiElement, String> getCommonTooltip(final List<MergeableLineMarkerInfo> infos) {
        return new Function<PsiElement, String>(){

            public String fun(PsiElement element) {
                Set tooltips = ContainerUtil.map2Set((Collection)infos, (Function)new Function<MergeableLineMarkerInfo, String>(){

                    public String fun(MergeableLineMarkerInfo info) {
                        return info.getLineMarkerTooltip();
                    }
                });
                StringBuilder tooltip = new StringBuilder();
                for (String info : tooltips) {
                    if (tooltip.length() > 0) {
                        tooltip.append("<hr size=1 noshade>");
                    }
                    if (info == null) continue;
                    tooltip.append(UIUtil.getHtmlBody((String)info));
                }
                return XmlStringUtil.wrapInHtml((CharSequence)tooltip);
            }
        };
    }

    private static class RelatedItemLineMarkerGutterIconRenderer<T extends PsiElement>
    extends LineMarkerInfo.LineMarkerGutterIconRenderer<T> {
        public RelatedItemLineMarkerGutterIconRenderer(RelatedItemLineMarkerInfo<T> markerInfo) {
            super(markerInfo);
        }

        @Override
        protected boolean looksTheSameAs(LineMarkerInfo.LineMarkerGutterIconRenderer renderer) {
            if (!(renderer instanceof RelatedItemLineMarkerGutterIconRenderer) || !super.looksTheSameAs(renderer)) {
                return false;
            }
            RelatedItemLineMarkerInfo markerInfo = (RelatedItemLineMarkerInfo)this.getLineMarkerInfo();
            RelatedItemLineMarkerInfo otherInfo = (RelatedItemLineMarkerInfo)renderer.getLineMarkerInfo();
            return markerInfo.myTargets.equals(otherInfo.myTargets);
        }
    }
}

