/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.LightDaemonAnalyzerTestCase;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.quickFix.QuickFixTestCase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiFile;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NonNls;

public abstract class LightQuickFixTestCase
extends LightDaemonAnalyzerTestCase {
    @NonNls
    protected static final String BEFORE_PREFIX = "before";
    @NonNls
    protected static final String AFTER_PREFIX = "after";
    private static QuickFixTestCase myWrapper;

    protected boolean shouldBeAvailableAfterExecution() {
        return false;
    }

    protected Pair<String, Boolean> parseActionHintImpl(PsiFile file, String contents) {
        return LightQuickFixTestCase.parseActionHint(file, contents);
    }

    private static void doTestFor(final String testName, final QuickFixTestCase quickFixTestCase) {
        String relativePath = (String)ObjectUtils.notNull((Object)quickFixTestCase.getBasePath(), (Object)"") + "/" + BEFORE_PREFIX + testName;
        final String testFullPath = quickFixTestCase.getTestDataPath().replace(File.separatorChar, '/') + relativePath;
        final File testFile = new File(testFullPath);
        CommandProcessor.getInstance().executeCommand(quickFixTestCase.getProject(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String contents = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)testFile, (Charset)CharsetToolkit.UTF8_CHARSET));
                    quickFixTestCase.configureFromFileText(testFile.getName(), contents);
                    quickFixTestCase.bringRealEditorBack();
                    Pair<String, Boolean> pair = quickFixTestCase.parseActionHintImpl(quickFixTestCase.getFile(), contents);
                    String text = (String)pair.getFirst();
                    boolean actionShouldBeAvailable = (Boolean)pair.getSecond();
                    quickFixTestCase.beforeActionStarted(testName, contents);
                    try {
                        myWrapper = quickFixTestCase;
                        quickFixTestCase.doAction(text, actionShouldBeAvailable, testFullPath, testName);
                    }
                    finally {
                        myWrapper = null;
                        quickFixTestCase.afterActionCompleted(testName, contents);
                    }
                }
                catch (FileComparisonFailure e) {
                    throw e;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    TestCase.fail((String)testName);
                }
            }
        }, "", "");
    }

    protected void afterActionCompleted(String testName, String contents) {
    }

    protected void beforeActionStarted(String testName, String contents) {
    }

    public static Pair<String, Boolean> parseActionHint(PsiFile file, String contents) {
        return LightQuickFixTestCase.parseActionHint(file, contents, " \"(.*)\" \"(true|false)\".*");
    }

    public static Pair<String, Boolean> parseActionHint(PsiFile file, String contents, @NonNls @RegExp String actionPattern) {
        PsiFile hostFile = InjectedLanguageManager.getInstance(file.getProject()).getTopLevelFile(file);
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(hostFile.getLanguage());
        String comment = commenter.getLineCommentPrefix();
        if (comment == null) {
            comment = commenter.getBlockCommentPrefix();
        }
        assert (comment != null) : commenter;
        Pattern pattern = Pattern.compile("^" + comment.replace("*", "\\*") + actionPattern, 32);
        Matcher matcher = pattern.matcher(contents);
        LightQuickFixTestCase.assertTrue((String)("No comment found in " + file.getVirtualFile()), (boolean)matcher.matches());
        String text = matcher.group(1);
        Boolean actionShouldBeAvailable = Boolean.valueOf(matcher.group(2));
        return Pair.create((Object)text, (Object)actionShouldBeAvailable);
    }

    public static void doAction(String text, boolean actionShouldBeAvailable, String testFullPath, String testName, QuickFixTestCase quickFix) throws Exception {
        IntentionAction action = quickFix.findActionWithText(text);
        if (action == null) {
            if (actionShouldBeAvailable) {
                List<IntentionAction> actions = quickFix.getAvailableActions();
                ArrayList<String> texts = new ArrayList<String>();
                for (IntentionAction intentionAction : actions) {
                    texts.add(intentionAction.getText());
                }
                List<HighlightInfo> infos = quickFix.doHighlighting();
                LightQuickFixTestCase.fail((String)("Action with text '" + text + "' is not available in test " + testFullPath + "\n" + "Available actions (" + texts.size() + "): " + texts + "\n" + actions + "\nInfos:" + infos));
            }
        } else {
            IntentionAction afterAction;
            if (!actionShouldBeAvailable) {
                LightQuickFixTestCase.fail((String)("Action '" + text + "' is available (but must not) in test " + testFullPath));
            }
            quickFix.invoke(action);
            UIUtil.dispatchAllInvocationEvents();
            UIUtil.dispatchAllInvocationEvents();
            if (!quickFix.shouldBeAvailableAfterExecution() && (afterAction = quickFix.findActionWithText(text)) != null) {
                LightQuickFixTestCase.fail((String)("Action '" + text + "' is still available after its invocation in test " + testFullPath));
            }
            String expectedFilePath = (String)ObjectUtils.notNull((Object)quickFix.getBasePath(), (Object)"") + "/" + AFTER_PREFIX + testName;
            quickFix.checkResultByFile("In file :" + expectedFilePath, expectedFilePath, false);
        }
    }

    protected void doAction(String text, boolean actionShouldBeAvailable, String testFullPath, String testName) throws Exception {
        LightQuickFixTestCase.doAction(text, actionShouldBeAvailable, testFullPath, testName, myWrapper);
    }

    protected void doAction(String actionName) {
        List<IntentionAction> available = this.getAvailableActions();
        IntentionAction action = LightQuickFixTestCase.findActionWithText(available, actionName);
        LightQuickFixTestCase.assertNotNull((String)("Action '" + actionName + "' not found among " + available.toString()), (Object)action);
        LightQuickFixTestCase.invoke(action);
    }

    protected static void invoke(IntentionAction action) throws IncorrectOperationException {
        ShowIntentionActionsHandler.chooseActionAndInvoke((PsiFile)LightQuickFixTestCase.getFile(), (Editor)LightQuickFixTestCase.getEditor(), (IntentionAction)action, (String)action.getText());
        UIUtil.dispatchAllInvocationEvents();
    }

    protected IntentionAction findActionWithText(String text) {
        return LightQuickFixTestCase.findActionWithText(this.getAvailableActions(), text);
    }

    public static IntentionAction findActionWithText(List<IntentionAction> actions, String text) {
        for (IntentionAction action : actions) {
            if (!text.equals(action.getText())) continue;
            return action;
        }
        return null;
    }

    protected void doAllTests() {
        LightQuickFixTestCase.doAllTests(this.createWrapper());
    }

    public static void doAllTests(QuickFixTestCase testCase) {
        LightQuickFixTestCase.assertNotNull((String)"getBasePath() should not return null!", (Object)testCase.getBasePath());
        String testDirPath = testCase.getTestDataPath().replace(File.separatorChar, '/') + testCase.getBasePath();
        File testDir = new File(testDirPath);
        File[] files = testDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, @NonNls String name) {
                return name.startsWith(LightQuickFixTestCase.BEFORE_PREFIX);
            }
        });
        if (files == null || files.length == 0) {
            LightQuickFixTestCase.fail((String)("Test files not found in " + testDirPath));
        }
        for (File file : files) {
            String testName = file.getName().substring(BEFORE_PREFIX.length());
            LightQuickFixTestCase.doTestFor(testName, testCase);
        }
    }

    protected void doSingleTest(String fileSuffix) {
        LightQuickFixTestCase.doTestFor(fileSuffix, this.createWrapper());
    }

    protected void doSingleTest(String fileSuffix, String testDataPath) {
        LightQuickFixTestCase.doTestFor(fileSuffix, this.createWrapper(testDataPath));
    }

    protected QuickFixTestCase createWrapper() {
        return this.createWrapper(null);
    }

    protected QuickFixTestCase createWrapper(final String testDataPath) {
        return new QuickFixTestCase(){
            public String myTestDataPath;
            {
                this.myTestDataPath = testDataPath;
            }

            @Override
            public String getBasePath() {
                return LightQuickFixTestCase.this.getBasePath();
            }

            @Override
            public String getTestDataPath() {
                if (this.myTestDataPath == null) {
                    this.myTestDataPath = LightQuickFixTestCase.this.getTestDataPath();
                }
                return this.myTestDataPath;
            }

            @Override
            public Pair<String, Boolean> parseActionHintImpl(PsiFile file, String contents) {
                return LightQuickFixTestCase.this.parseActionHintImpl(file, contents);
            }

            @Override
            public void beforeActionStarted(String testName, String contents) {
                LightQuickFixTestCase.this.beforeActionStarted(testName, contents);
            }

            @Override
            public void afterActionCompleted(String testName, String contents) {
                LightQuickFixTestCase.this.afterActionCompleted(testName, contents);
            }

            @Override
            public void doAction(String text, boolean actionShouldBeAvailable, String testFullPath, String testName) throws Exception {
                LightQuickFixTestCase.this.doAction(text, actionShouldBeAvailable, testFullPath, testName);
            }

            @Override
            public void checkResultByFile(String s, String expectedFilePath, boolean b) throws Exception {
                LightQuickFixTestCase.this.checkResultByFile(s, expectedFilePath, b);
            }

            @Override
            public IntentionAction findActionWithText(String text) {
                return LightQuickFixTestCase.this.findActionWithText(text);
            }

            @Override
            public boolean shouldBeAvailableAfterExecution() {
                return LightQuickFixTestCase.this.shouldBeAvailableAfterExecution();
            }

            @Override
            public void invoke(IntentionAction action) {
                LightQuickFixTestCase.invoke(action);
            }

            @Override
            public List<HighlightInfo> doHighlighting() {
                return LightQuickFixTestCase.this.doHighlighting();
            }

            @Override
            public List<IntentionAction> getAvailableActions() {
                return LightQuickFixTestCase.this.getAvailableActions();
            }

            @Override
            public void configureFromFileText(String name, String contents) throws IOException {
                LightQuickFixTestCase.configureFromFileText((String)name, (String)contents);
            }

            @Override
            public PsiFile getFile() {
                return LightQuickFixTestCase.getFile();
            }

            @Override
            public Project getProject() {
                return LightPlatformTestCase.getProject();
            }

            @Override
            public void bringRealEditorBack() {
                LightQuickFixTestCase.bringRealEditorBack();
            }
        };
    }

    protected List<IntentionAction> getAvailableActions() {
        this.doHighlighting();
        return LightQuickFixTestCase.getAvailableActions(LightQuickFixTestCase.getEditor(), LightQuickFixTestCase.getFile());
    }

    public static List<IntentionAction> getAvailableActions(Editor editor, PsiFile file) {
        return CodeInsightTestFixtureImpl.getAvailableIntentions((Editor)editor, (PsiFile)file);
    }

    @NonNls
    protected String getBasePath() {
        return null;
    }
}

