/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;

public abstract class SmartEnterProcessor {
    public abstract boolean process(Project var1, Editor var2, PsiFile var3);

    public boolean processAfterCompletion(Editor editor, PsiFile psiFile) {
        return this.process(psiFile.getProject(), editor, psiFile);
    }

    protected void reformat(PsiElement atCaret) throws IncorrectOperationException {
        TextRange range = atCaret.getTextRange();
        PsiFile file = atCaret.getContainingFile();
        PsiFile baseFile = file.getViewProvider().getPsi(file.getViewProvider().getBaseLanguage());
        CodeStyleManager.getInstance(atCaret.getProject()).reformatText(baseFile, range.getStartOffset(), range.getEndOffset());
    }

    protected RangeMarker createRangeMarker(PsiElement elt) {
        PsiFile psiFile = elt.getContainingFile();
        PsiDocumentManager instance = PsiDocumentManager.getInstance(elt.getProject());
        Document document = instance.getDocument(psiFile);
        return document.createRangeMarker(elt.getTextRange());
    }

    protected PsiElement getStatementAtCaret(Editor editor, PsiFile psiFile) {
        int offset;
        int caret = editor.getCaretModel().getOffset();
        Document doc = editor.getDocument();
        CharSequence chars = doc.getCharsSequence();
        int n = offset = caret == 0 ? 0 : CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caret - 1), (String)" \t");
        if (doc.getLineNumber(offset) < doc.getLineNumber(caret)) {
            offset = CharArrayUtil.shiftForward((CharSequence)chars, (int)caret, (String)" \t");
        }
        return psiFile.findElementAt(offset);
    }

    protected static boolean isUncommited(Project project) {
        return PsiDocumentManager.getInstance(project).hasUncommitedDocuments();
    }

    protected void commit(Editor editor) {
        Project project = editor.getProject();
        PsiDocumentManager.getInstance(project).commitDocument(editor.getDocument());
        PsiDocumentManager.getInstance(project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
    }
}

