/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;

public abstract class PriorityIntentionActionWrapper
implements IntentionAction {
    private final IntentionAction action;

    private PriorityIntentionActionWrapper(IntentionAction action) {
        this.action = action;
    }

    @Override
    public String getText() {
        return this.action.getText();
    }

    @Override
    public String getFamilyName() {
        return this.action.getFamilyName();
    }

    @Override
    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        return this.action.isAvailable(project, editor, file);
    }

    @Override
    public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.action.invoke(project, editor, file);
    }

    @Override
    public boolean startInWriteAction() {
        return this.action.startInWriteAction();
    }

    public static IntentionAction highPriority(IntentionAction action) {
        return new HighPriorityIntentionActionWrapper(action);
    }

    public static IntentionAction normalPriority(IntentionAction action) {
        return new NormalPriorityIntentionActionWrapper(action);
    }

    public static IntentionAction lowPriority(IntentionAction action) {
        return new LowPriorityIntentionActionWrapper(action);
    }

    private static class LowPriorityIntentionActionWrapper
    extends PriorityIntentionActionWrapper
    implements LowPriorityAction {
        protected LowPriorityIntentionActionWrapper(IntentionAction action) {
            super(action);
        }
    }

    private static class NormalPriorityIntentionActionWrapper
    extends PriorityIntentionActionWrapper {
        protected NormalPriorityIntentionActionWrapper(IntentionAction action) {
            super(action);
        }
    }

    private static class HighPriorityIntentionActionWrapper
    extends PriorityIntentionActionWrapper
    implements HighPriorityAction {
        protected HighPriorityIntentionActionWrapper(IntentionAction action) {
            super(action);
        }
    }
}

