/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.util.PsiUtilCore;
import gnu.trove.THashSet;
import java.awt.Color;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;

public final class LookupElementBuilder
extends LookupElement {
    private final String myLookupString;
    private final Object myObject;
    private final boolean myCaseSensitive;
    private final InsertHandler<LookupElement> myInsertHandler;
    private final LookupElementRenderer<LookupElement> myRenderer;
    private final LookupElementPresentation myHardcodedPresentation;
    private final Set<String> myAllLookupStrings;

    private LookupElementBuilder(String lookupString, Object object, InsertHandler<LookupElement> insertHandler, LookupElementRenderer<LookupElement> renderer, LookupElementPresentation hardcodedPresentation, Set<String> allLookupStrings, boolean caseSensitive) {
        this.myLookupString = lookupString;
        this.myObject = object;
        this.myInsertHandler = insertHandler;
        this.myRenderer = renderer;
        this.myHardcodedPresentation = hardcodedPresentation;
        this.myAllLookupStrings = allLookupStrings;
        this.myCaseSensitive = caseSensitive;
    }

    private LookupElementBuilder(String lookupString, Object object) {
        this(lookupString, object, null, null, null, Collections.singleton(lookupString), true);
    }

    public static LookupElementBuilder create(String lookupString) {
        return new LookupElementBuilder(lookupString, lookupString);
    }

    public static LookupElementBuilder createWithSmartPointer(String lookupString, PsiElement element) {
        PsiUtilCore.ensureValid(element);
        return new LookupElementBuilder(lookupString, SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element));
    }

    public static LookupElementBuilder create(PsiNamedElement element) {
        PsiUtilCore.ensureValid(element);
        return new LookupElementBuilder(StringUtil.notNullize((String)element.getName()), element);
    }

    public static LookupElementBuilder createWithIcon(PsiNamedElement element) {
        PsiUtilCore.ensureValid(element);
        return LookupElementBuilder.create(element).withIcon(element.getIcon(0));
    }

    public static LookupElementBuilder create(Object lookupObject, String lookupString) {
        if (lookupObject instanceof PsiElement) {
            PsiUtilCore.ensureValid((PsiElement)lookupObject);
        }
        return new LookupElementBuilder(lookupString, lookupObject);
    }

    public LookupElementBuilder setInsertHandler(InsertHandler<LookupElement> insertHandler) {
        return this.withInsertHandler(insertHandler);
    }

    public LookupElementBuilder withInsertHandler(InsertHandler<LookupElement> insertHandler) {
        return new LookupElementBuilder(this.myLookupString, this.myObject, insertHandler, this.myRenderer, this.myHardcodedPresentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setRenderer(LookupElementRenderer<LookupElement> renderer) {
        return this.withRenderer(renderer);
    }

    public LookupElementBuilder withRenderer(LookupElementRenderer<LookupElement> renderer) {
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, renderer, this.myHardcodedPresentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Override
    public Set<String> getAllLookupStrings() {
        return this.myAllLookupStrings;
    }

    public LookupElementBuilder setIcon(Icon icon) {
        return this.withIcon(icon);
    }

    public LookupElementBuilder withIcon(Icon icon) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setIcon(icon);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    private LookupElementPresentation copyPresentation() {
        LookupElementPresentation presentation = new LookupElementPresentation();
        if (this.myHardcodedPresentation != null) {
            presentation.copyFrom(this.myHardcodedPresentation);
        } else {
            presentation.setItemText(this.myLookupString);
        }
        return presentation;
    }

    public LookupElementBuilder addLookupString(String another) {
        return this.withLookupString(another);
    }

    public LookupElementBuilder withLookupString(String another) {
        THashSet set = new THashSet(this.myAllLookupStrings);
        set.add((Object)another);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myHardcodedPresentation, Collections.unmodifiableSet(set), this.myCaseSensitive);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public LookupElementBuilder setCaseSensitive(boolean caseSensitive) {
        return this.withCaseSensitivity(caseSensitive);
    }

    public LookupElementBuilder withCaseSensitivity(boolean caseSensitive) {
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myHardcodedPresentation, this.myAllLookupStrings, caseSensitive);
    }

    public LookupElementBuilder setItemTextForeground(Color itemTextForeground) {
        return this.withItemTextForeground(itemTextForeground);
    }

    public LookupElementBuilder withItemTextForeground(Color itemTextForeground) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextForeground(itemTextForeground);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setItemTextUnderlined(boolean underlined) {
        return this.withItemTextUnderlined(underlined);
    }

    public LookupElementBuilder withItemTextUnderlined(boolean underlined) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextUnderlined(underlined);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setTypeText(String typeText) {
        return this.withTypeText(typeText);
    }

    public LookupElementBuilder withTypeText(String typeText) {
        return this.withTypeText(typeText, false);
    }

    public LookupElementBuilder setTypeText(String typeText, boolean grayed) {
        return this.withTypeText(typeText, grayed);
    }

    public LookupElementBuilder withTypeText(String typeText, boolean grayed) {
        return this.withTypeText(typeText, null, grayed);
    }

    public LookupElementBuilder withTypeText(String typeText, Icon typeIcon, boolean grayed) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTypeText(typeText, typeIcon);
        presentation.setTypeGrayed(grayed);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setPresentableText(String presentableText) {
        return this.withPresentableText(presentableText);
    }

    public LookupElementBuilder withPresentableText(String presentableText) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemText(presentableText);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setBold() {
        return this.bold();
    }

    public LookupElementBuilder bold() {
        return this.withBoldness(true);
    }

    public LookupElementBuilder setBold(boolean bold) {
        return this.withBoldness(bold);
    }

    public LookupElementBuilder withBoldness(boolean bold) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextBold(bold);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setStrikeout() {
        return this.strikeout();
    }

    public LookupElementBuilder strikeout() {
        return this.withStrikeoutness(true);
    }

    public LookupElementBuilder setStrikeout(boolean strikeout) {
        return this.withStrikeoutness(strikeout);
    }

    public LookupElementBuilder withStrikeoutness(boolean strikeout) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setStrikeout(strikeout);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder setTailText(String tailText) {
        return this.withTailText(tailText);
    }

    public LookupElementBuilder withTailText(String tailText) {
        return this.withTailText(tailText, false);
    }

    public LookupElementBuilder setTailText(String tailText, boolean grayed) {
        return this.withTailText(tailText, grayed);
    }

    public LookupElementBuilder withTailText(String tailText, boolean grayed) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTailText(tailText, grayed);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder appendTailText(String tailText, boolean grayed) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.appendTailText(tailText, grayed);
        return new LookupElementBuilder(this.myLookupString, this.myObject, this.myInsertHandler, null, presentation, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElement withAutoCompletionPolicy(AutoCompletionPolicy policy) {
        return policy.applyPolicy(this);
    }

    @Override
    public String getLookupString() {
        return this.myLookupString;
    }

    @Override
    public Object getObject() {
        return this.myObject;
    }

    @Override
    public void handleInsert(InsertionContext context) {
        if (this.myInsertHandler != null) {
            this.myInsertHandler.handleInsert(context, this);
        }
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        if (this.myRenderer != null) {
            this.myRenderer.renderElement(this, presentation);
        } else if (this.myHardcodedPresentation != null) {
            presentation.copyFrom(this.myHardcodedPresentation);
        } else {
            presentation.setItemText(this.myLookupString);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LookupElementBuilder that = (LookupElementBuilder)((Object)o);
        InsertHandler<LookupElement> insertHandler = that.myInsertHandler;
        if (this.myInsertHandler != null && insertHandler != null ? !this.myInsertHandler.getClass().equals(insertHandler.getClass()) : this.myInsertHandler != insertHandler) {
            return false;
        }
        if (!this.myLookupString.equals(that.myLookupString)) {
            return false;
        }
        if (!this.myObject.equals(that.myObject)) {
            return false;
        }
        LookupElementRenderer<LookupElement> renderer = that.myRenderer;
        return !(this.myRenderer != null && renderer != null ? !this.myRenderer.getClass().equals(renderer.getClass()) : this.myRenderer != renderer);
    }

    @Override
    public String toString() {
        return "LookupElementBuilder: string=" + this.getLookupString() + "; handler=" + this.myInsertHandler;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.myInsertHandler != null ? this.myInsertHandler.getClass().hashCode() : 0);
        result = 31 * result + this.myLookupString.hashCode();
        result = 31 * result + this.myObject.hashCode();
        result = 31 * result + (this.myRenderer != null ? this.myRenderer.getClass().hashCode() : 0);
        return result;
    }
}

