/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public class LookupElementPresentation {
    private Icon myIcon;
    private Icon myTypeIcon;
    private String myItemText;
    private String myTypeText;
    private boolean myStrikeout;
    private Color myItemTextForeground = JBColor.foreground();
    private boolean myItemTextBold;
    private boolean myItemTextUnderlined;
    private boolean myTypeGrayed;
    private List<TextFragment> myTail;

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public void setItemText(String text) {
        this.myItemText = text;
    }

    public void setStrikeout(boolean strikeout) {
        this.myStrikeout = strikeout;
    }

    public void setItemTextBold(boolean bold) {
        this.myItemTextBold = bold;
    }

    public void setTailText(String text) {
        this.setTailText(text, false);
    }

    public void clearTail() {
        this.myTail = null;
    }

    public void appendTailText(String text, boolean grayed) {
        this.appendTailText(new TextFragment(text, grayed, null));
    }

    private void appendTailText(TextFragment fragment) {
        if (this.myTail == null) {
            this.myTail = new SmartList();
        }
        this.myTail.add(fragment);
    }

    public void setTailText(String text, boolean grayed) {
        this.clearTail();
        if (text != null) {
            this.appendTailText(new TextFragment(text, grayed, null));
        }
    }

    public void setTailText(String text, Color foreground) {
        this.clearTail();
        if (text != null) {
            this.appendTailText(new TextFragment(text, false, foreground));
        }
    }

    public void setTypeText(String text) {
        this.setTypeText(text, null);
    }

    public void setTypeText(String text, Icon icon) {
        this.myTypeText = text;
        this.myTypeIcon = icon;
    }

    public boolean isReal() {
        return false;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public Icon getTypeIcon() {
        return this.myTypeIcon;
    }

    public String getItemText() {
        return this.myItemText;
    }

    public List<TextFragment> getTailFragments() {
        return this.myTail == null ? Collections.emptyList() : Collections.unmodifiableList(this.myTail);
    }

    public String getTailText() {
        if (this.myTail == null) {
            return null;
        }
        return StringUtil.join(this.myTail, (Function)new Function<TextFragment, String>(){

            public String fun(TextFragment fragment) {
                return fragment.text;
            }
        }, (String)"");
    }

    public String getTypeText() {
        return this.myTypeText;
    }

    public boolean isStrikeout() {
        return this.myStrikeout;
    }

    @Deprecated
    public boolean isTailGrayed() {
        return this.myTail != null && this.myTail.get(0).grayed;
    }

    @Deprecated
    public Color getTailForeground() {
        return this.myTail != null ? this.myTail.get(0).fgColor : null;
    }

    public boolean isItemTextBold() {
        return this.myItemTextBold;
    }

    public boolean isItemTextUnderlined() {
        return this.myItemTextUnderlined;
    }

    public void setItemTextUnderlined(boolean itemTextUnderlined) {
        this.myItemTextUnderlined = itemTextUnderlined;
    }

    public Color getItemTextForeground() {
        return this.myItemTextForeground;
    }

    public void setItemTextForeground(Color itemTextForeground) {
        this.myItemTextForeground = itemTextForeground;
    }

    public void copyFrom(LookupElementPresentation presentation) {
        this.myIcon = presentation.myIcon;
        this.myTypeIcon = presentation.myTypeIcon;
        this.myItemText = presentation.myItemText;
        List<TextFragment> thatTail = presentation.myTail;
        this.myTail = thatTail == null ? null : new SmartList(thatTail);
        this.myTypeText = presentation.myTypeText;
        this.myStrikeout = presentation.myStrikeout;
        this.myItemTextBold = presentation.myItemTextBold;
        this.myTypeGrayed = presentation.myTypeGrayed;
        this.myItemTextUnderlined = presentation.myItemTextUnderlined;
        this.myItemTextForeground = presentation.myItemTextForeground;
    }

    public boolean isTypeGrayed() {
        return this.myTypeGrayed;
    }

    public void setTypeGrayed(boolean typeGrayed) {
        this.myTypeGrayed = typeGrayed;
    }

    public static LookupElementPresentation renderElement(LookupElement element) {
        LookupElementPresentation presentation = new LookupElementPresentation();
        element.renderElement(presentation);
        return presentation;
    }

    public String toString() {
        return "LookupElementPresentation{, itemText='" + this.myItemText + '\'' + ", tail=" + this.myTail + ", typeText='" + this.myTypeText + '\'' + '}';
    }

    public static class TextFragment {
        public final String text;
        private final boolean grayed;
        private final Color fgColor;

        public TextFragment(String text, boolean grayed, Color fgColor) {
            this.text = text;
            this.grayed = grayed;
            this.fgColor = fgColor;
        }

        public String toString() {
            return "TextFragment{text='" + this.text + '\'' + ", grayed=" + this.grayed + ", fgColor=" + this.fgColor + '}';
        }

        public boolean isGrayed() {
            return this.grayed;
        }

        public Color getForegroundColor() {
            return this.fgColor;
        }
    }
}

