/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;

public class InspectionEP
extends LanguageExtensionPoint
implements InspectionProfileEntry.DefaultNameProvider {
    public static final ExtensionPointName<InspectionEP> GLOBAL_INSPECTION = ExtensionPointName.create((String)"com.intellij.globalInspection");
    @Attribute(value="shortName")
    public String shortName;
    @Attribute(value="key")
    public String key;
    @Attribute(value="bundle")
    public String bundle;
    @Attribute(value="displayName")
    public String displayName;
    @Attribute(value="groupKey")
    public String groupKey;
    @Attribute(value="groupBundle")
    public String groupBundle;
    @Attribute(value="groupName")
    public String groupDisplayName;
    @Attribute(value="groupPath")
    public String groupPath;
    @Attribute(value="enabledByDefault")
    public boolean enabledByDefault = false;
    @Attribute(value="applyToDialects")
    public boolean applyToDialects = true;
    @Attribute(value="cleanupTool")
    public boolean cleanupTool = false;
    @Attribute(value="level")
    public String level;
    @Attribute(value="hasStaticDescription")
    public boolean hasStaticDescription;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.InspectionEP");
    @Attribute(value="presentation")
    public String presentation;

    public String getShortName() {
        if (this.implementationClass == null) {
            throw new IllegalArgumentException(this.toString());
        }
        return this.shortName == null ? InspectionProfileEntry.getShortName(StringUtil.getShortName((String)this.implementationClass)) : this.shortName;
    }

    public String getDisplayName() {
        return this.displayName == null ? (this.displayName = this.getLocalizedString(this.bundle, this.key)) : this.displayName;
    }

    public String getGroupDisplayName() {
        return this.groupDisplayName == null ? (this.groupDisplayName = this.getLocalizedString(this.groupBundle, this.groupKey)) : this.groupDisplayName;
    }

    public String[] getGroupPath() {
        String name = this.getGroupDisplayName();
        if (name == null) {
            return null;
        }
        if (this.groupPath == null) {
            return new String[]{name.isEmpty() ? InspectionProfileEntry.GENERAL_GROUP_NAME : name};
        }
        return (String[])ArrayUtil.append((Object[])this.groupPath.split(","), (Object)name);
    }

    public HighlightDisplayLevel getDefaultLevel() {
        if (this.level == null) {
            return HighlightDisplayLevel.WARNING;
        }
        HighlightDisplayLevel displayLevel = HighlightDisplayLevel.find(this.level);
        if (displayLevel == null) {
            LOG.error("Can't find highlight display level: " + this.level);
            return HighlightDisplayLevel.WARNING;
        }
        return displayLevel;
    }

    private String getLocalizedString(String bundleName, String key) {
        String baseName;
        String string = bundleName != null ? bundleName : (baseName = this.bundle == null ? ((IdeaPluginDescriptor)this.myPluginDescriptor).getResourceBundleBaseName() : this.bundle);
        if (baseName == null || key == null) {
            if (bundleName != null) {
                LOG.warn(this.implementationClass);
            }
            return null;
        }
        ResourceBundle resourceBundle = AbstractBundle.getResourceBundle((String)baseName, (ClassLoader)this.myPluginDescriptor.getPluginClassLoader());
        return CommonBundle.message((ResourceBundle)resourceBundle, (String)key, (Object[])new Object[0]);
    }

    public InspectionProfileEntry instantiateTool() {
        try {
            InspectionProfileEntry entry = (InspectionProfileEntry)this.instantiate(this.implementationClass, ApplicationManager.getApplication().getPicoContainer());
            entry.myNameProvider = this;
            return entry;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDefaultShortName() {
        return this.getShortName();
    }

    @Override
    public String getDefaultDisplayName() {
        return this.getDisplayName();
    }

    @Override
    public String getDefaultGroupDisplayName() {
        return this.getGroupDisplayName();
    }

    @NonNls
    public String toString() {
        return "InspectionEP{shortName='" + this.shortName + '\'' + ", key='" + this.key + '\'' + ", bundle='" + this.bundle + '\'' + ", displayName='" + this.displayName + '\'' + ", groupKey='" + this.groupKey + '\'' + ", groupBundle='" + this.groupBundle + '\'' + ", groupDisplayName='" + this.groupDisplayName + '\'' + ", groupPath='" + this.groupPath + '\'' + ", enabledByDefault=" + this.enabledByDefault + ", applyToDialects=" + this.applyToDialects + ", level='" + this.level + '\'' + ", hasStaticDescription=" + this.hasStaticDescription + ", presentation='" + this.presentation + '\'' + '}';
    }
}

