/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.BatchSuppressableTool;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.ResourceUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public abstract class InspectionProfileEntry
implements BatchSuppressableTool {
    public static final String GENERAL_GROUP_NAME = InspectionsBundle.message("inspection.general.tools.group.name", new Object[0]);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.InspectionProfileEntry");
    private static final SkipDefaultValuesSerializationFilters DEFAULT_FILTER = new SkipDefaultValuesSerializationFilters();
    private static Set<String> ourBlackList = null;
    private static final Object BLACK_LIST_LOCK = new Object();
    private Boolean myUseNewSerializer = null;
    protected volatile DefaultNameProvider myNameProvider = null;

    @NonNls
    public String getAlternativeID() {
        return null;
    }

    @Override
    public boolean isSuppressedFor(PsiElement element) {
        Set<InspectionSuppressor> suppressors = InspectionProfileEntry.getSuppressors(element);
        String toolId = this.getSuppressId();
        for (InspectionSuppressor suppressor : suppressors) {
            if (!this.isSuppressed(toolId, suppressor, element)) continue;
            return true;
        }
        return false;
    }

    protected String getSuppressId() {
        return this.getShortName();
    }

    @Override
    public SuppressQuickFix[] getBatchSuppressActions(PsiElement element) {
        if (element == null) {
            return SuppressQuickFix.EMPTY_ARRAY;
        }
        THashSet fixes = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<SuppressQuickFix>(){

            public int computeHashCode(SuppressQuickFix object) {
                int result = object instanceof InjectionAwareSuppressQuickFix ? ((InjectionAwareSuppressQuickFix)object).isShouldBeAppliedToInjectionHost().hashCode() : 0;
                return 31 * result + object.getName().hashCode();
            }

            public boolean equals(SuppressQuickFix o1, SuppressQuickFix o2) {
                if (o1 instanceof InjectionAwareSuppressQuickFix && o2 instanceof InjectionAwareSuppressQuickFix && ((InjectionAwareSuppressQuickFix)o1).isShouldBeAppliedToInjectionHost() != ((InjectionAwareSuppressQuickFix)o2).isShouldBeAppliedToInjectionHost()) {
                    return false;
                }
                return o1.getName().equals(o2.getName());
            }
        });
        Set<InspectionSuppressor> suppressors = InspectionProfileEntry.getSuppressors(element);
        PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance(element.getProject()).getInjectionHost(element);
        if (injectionHost != null) {
            Set<InspectionSuppressor> injectionHostSuppressors = InspectionProfileEntry.getSuppressors(injectionHost);
            for (InspectionSuppressor suppressor : injectionHostSuppressors) {
                InspectionProfileEntry.addAllSuppressActions((Set<SuppressQuickFix>)fixes, injectionHost, suppressor, ThreeState.YES, this.getShortName());
            }
        }
        for (InspectionSuppressor suppressor : suppressors) {
            InspectionProfileEntry.addAllSuppressActions((Set<SuppressQuickFix>)fixes, element, suppressor, injectionHost != null ? ThreeState.NO : ThreeState.UNSURE, this.getShortName());
        }
        return fixes.toArray(new SuppressQuickFix[fixes.size()]);
    }

    private static void addAllSuppressActions(Set<SuppressQuickFix> fixes, PsiElement element, InspectionSuppressor suppressor, ThreeState appliedToInjectionHost, String toolShortName) {
        SuppressQuickFix[] actions;
        for (SuppressQuickFix action : actions = suppressor.getSuppressActions(element, toolShortName)) {
            if (action instanceof InjectionAwareSuppressQuickFix) {
                ((InjectionAwareSuppressQuickFix)action).setShouldBeAppliedToInjectionHost(appliedToInjectionHost);
            }
            fixes.add(action);
        }
    }

    private boolean isSuppressed(String toolId, InspectionSuppressor suppressor, PsiElement element) {
        if (suppressor.isSuppressedFor(element, toolId)) {
            return true;
        }
        String alternativeId = this.getAlternativeID();
        return alternativeId != null && !alternativeId.equals(toolId) && suppressor.isSuppressedFor(element, alternativeId);
    }

    public static Set<InspectionSuppressor> getSuppressors(PsiElement element) {
        FileViewProvider viewProvider = element.getContainingFile().getViewProvider();
        InspectionSuppressor elementLanguageSuppressor = (InspectionSuppressor)LanguageInspectionSuppressors.INSTANCE.forLanguage(element.getLanguage());
        if (viewProvider instanceof TemplateLanguageFileViewProvider) {
            LinkedHashSet<InspectionSuppressor> suppressors = new LinkedHashSet<InspectionSuppressor>();
            ContainerUtil.addIfNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.forLanguage(viewProvider.getBaseLanguage()));
            for (Language language : viewProvider.getLanguages()) {
                ContainerUtil.addIfNotNull(suppressors, LanguageInspectionSuppressors.INSTANCE.forLanguage(language));
            }
            ContainerUtil.addIfNotNull(suppressors, (Object)elementLanguageSuppressor);
            return suppressors;
        }
        return elementLanguageSuppressor != null ? Collections.singleton(elementLanguageSuppressor) : Collections.emptySet();
    }

    public void cleanup(Project project) {
    }

    public String getGroupDisplayName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultGroupDisplayName()) != null) {
            return name;
        }
        LOG.error(this.getClass() + ": group display name should be overridden or configured via XML " + this.getClass());
        return "";
    }

    public String[] getGroupPath() {
        String groupDisplayName = this.getGroupDisplayName();
        if (groupDisplayName.isEmpty()) {
            groupDisplayName = GENERAL_GROUP_NAME;
        }
        return new String[]{groupDisplayName};
    }

    public String getDisplayName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultDisplayName()) != null) {
            return name;
        }
        LOG.error(this.getClass() + ": display name should be overridden or configured via XML " + this.getClass());
        return "";
    }

    @NonNls
    public String getShortName() {
        String name;
        if (this.myNameProvider != null && (name = this.myNameProvider.getDefaultShortName()) != null) {
            return name;
        }
        return InspectionProfileEntry.getShortName(this.getClass().getSimpleName());
    }

    public static String getShortName(String className) {
        return StringUtil.trimEnd((String)StringUtil.trimEnd((String)className, (String)"Inspection"), (String)"InspectionBase");
    }

    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.WARNING;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    public JComponent createOptionsPanel() {
        return null;
    }

    public void readSettings(Element node) throws InvalidDataException {
        if (this.useNewSerializer()) {
            try {
                XmlSerializer.deserializeInto((Object)this, (Element)node);
            }
            catch (XmlSerializationException e) {
                throw new InvalidDataException((Throwable)e);
            }
        } else {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)node);
        }
    }

    public void writeSettings(Element node) throws WriteExternalException {
        if (this.useNewSerializer()) {
            XmlSerializer.serializeInto((Object)this, (Element)node, (SerializationFilter)this.getSerializationFilter());
        } else {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)node);
        }
    }

    private synchronized boolean useNewSerializer() {
        if (this.myUseNewSerializer == null) {
            this.myUseNewSerializer = !InspectionProfileEntry.getBlackList().contains(this.getClass().getName());
        }
        return this.myUseNewSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadBlackList() {
        ourBlackList = ContainerUtil.newHashSet();
        URL url = InspectionProfileEntry.class.getResource("inspection-black-list.txt");
        if (url == null) {
            LOG.error("Resource not found");
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    ourBlackList.add(line);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            LOG.error("Unable to load resource: " + url, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> getBlackList() {
        Object object = BLACK_LIST_LOCK;
        synchronized (object) {
            if (ourBlackList == null) {
                InspectionProfileEntry.loadBlackList();
            }
            return ourBlackList;
        }
    }

    protected SerializationFilter getSerializationFilter() {
        return DEFAULT_FILTER;
    }

    public void projectOpened(Project project) {
    }

    public void projectClosed(Project project) {
    }

    public String getStaticDescription() {
        return null;
    }

    public String getDescriptionFileName() {
        return null;
    }

    protected URL getDescriptionUrl() {
        String fileName = this.getDescriptionFileName();
        if (fileName == null) {
            return null;
        }
        return ResourceUtil.getResource(this.getDescriptionContextClass(), (String)"/inspectionDescriptions", (String)fileName);
    }

    protected Class<? extends InspectionProfileEntry> getDescriptionContextClass() {
        return this.getClass();
    }

    public boolean isInitialized() {
        return true;
    }

    public String getMainToolId() {
        return null;
    }

    public String loadDescription() {
        String description = this.getStaticDescription();
        if (description != null) {
            return description;
        }
        try {
            URL descriptionUrl = this.getDescriptionUrl();
            if (descriptionUrl == null) {
                return null;
            }
            return ResourceUtil.loadText((URL)descriptionUrl);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static interface DefaultNameProvider {
        public String getDefaultShortName();

        public String getDefaultDisplayName();

        public String getDefaultGroupDisplayName();
    }
}

