/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NonNls;

public abstract class LocalInspectionTool
extends InspectionProfileEntry {
    public static final LocalInspectionTool[] EMPTY_ARRAY = new LocalInspectionTool[0];
    private static final Logger LOG = Logger.getInstance((String)("#" + LocalInspectionTool.class.getName()));
    @NonNls
    @Language(value="RegExp")
    public static final String VALID_ID_PATTERN = "[a-zA-Z_0-9.-]+";

    public static boolean isValidID(String id) {
        return !id.isEmpty() && id.matches(VALID_ID_PATTERN);
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NonNls
    public String getID() {
        String id;
        if (this.myNameProvider instanceof LocalDefaultNameProvider && (id = ((LocalDefaultNameProvider)this.myNameProvider).getDefaultID()) != null) {
            return id;
        }
        return this.getShortName();
    }

    @Override
    protected String getSuppressId() {
        return this.getID();
    }

    @Override
    @NonNls
    public String getAlternativeID() {
        if (this.myNameProvider instanceof LocalDefaultNameProvider) {
            return ((LocalDefaultNameProvider)this.myNameProvider).getDefaultAlternativeID();
        }
        return null;
    }

    public boolean runForWholeFile() {
        return false;
    }

    public ProblemDescriptor[] checkFile(PsiFile file, InspectionManager manager, boolean isOnTheFly) {
        return null;
    }

    public PsiElementVisitor buildVisitor(ProblemsHolder holder, boolean isOnTheFly, LocalInspectionToolSession session) {
        return this.buildVisitor(holder, isOnTheFly);
    }

    public PsiElementVisitor buildVisitor(final ProblemsHolder holder, final boolean isOnTheFly) {
        return new PsiElementVisitor(){

            @Override
            public void visitFile(PsiFile file) {
                this.addDescriptors(LocalInspectionTool.this.checkFile(file, holder.getManager(), isOnTheFly));
            }

            private void addDescriptors(ProblemDescriptor[] descriptors) {
                if (descriptors != null) {
                    for (ProblemDescriptor descriptor : descriptors) {
                        LOG.assertTrue(descriptor != null, (Object)LocalInspectionTool.this.getClass().getName());
                        holder.registerProblem(descriptor);
                    }
                }
            }
        };
    }

    public PsiNamedElement getProblemElement(PsiElement psiElement) {
        while (psiElement != null && !(psiElement instanceof PsiFile)) {
            psiElement = psiElement.getParent();
        }
        return (PsiFile)psiElement;
    }

    public void inspectionStarted(LocalInspectionToolSession session, boolean isOnTheFly) {
    }

    public void inspectionFinished(LocalInspectionToolSession session, ProblemsHolder problemsHolder) {
        this.inspectionFinished(session);
    }

    @Deprecated
    public void inspectionFinished(LocalInspectionToolSession session) {
    }

    public List<ProblemDescriptor> processFile(PsiFile file, InspectionManager manager) {
        ProblemsHolder holder = new ProblemsHolder(manager, file, false);
        LocalInspectionToolSession session = new LocalInspectionToolSession(file, 0, file.getTextLength());
        final PsiElementVisitor customVisitor = this.buildVisitor(holder, false, session);
        LOG.assertTrue(!(customVisitor instanceof PsiRecursiveElementVisitor), (Object)"The visitor returned from LocalInspectionTool.buildVisitor() must not be recursive");
        this.inspectionStarted(session, false);
        file.accept(new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                element.accept(customVisitor);
                super.visitElement(element);
            }
        });
        this.inspectionFinished(session, holder);
        return holder.getResults();
    }

    static interface LocalDefaultNameProvider
    extends InspectionProfileEntry.DefaultNameProvider {
        public String getDefaultID();

        public String getDefaultAlternativeID();
    }
}

