/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;

public class LocalQuickFixAsIntentionAdapter
implements IntentionAction {
    private final LocalQuickFix myFix;
    private final ProblemDescriptor myProblemDescriptor;

    public LocalQuickFixAsIntentionAdapter(LocalQuickFix fix, ProblemDescriptor problemDescriptor) {
        this.myFix = fix;
        this.myProblemDescriptor = problemDescriptor;
    }

    @Override
    public String getText() {
        return this.myFix.getName();
    }

    @Override
    public String getFamilyName() {
        return this.myFix.getFamilyName();
    }

    @Override
    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        return this.myProblemDescriptor.getStartElement() != null;
    }

    @Override
    public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.myFix.applyFix(project, this.myProblemDescriptor);
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }
}

