/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;

public abstract class SuppressIntentionAction
implements Iconable,
IntentionAction {
    private String myText = "";
    public static SuppressIntentionAction[] EMPTY_ARRAY = new SuppressIntentionAction[0];

    @Override
    public Icon getIcon(int flags) {
        return AllIcons.General.InspectionsOff;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    protected void setText(String text) {
        this.myText = text;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public final void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (!file.getManager().isInProject(file)) {
            return;
        }
        PsiElement element = SuppressIntentionAction.getElement(editor, file);
        if (element != null) {
            this.invoke(project, editor, element);
        }
    }

    public abstract void invoke(Project var1, Editor var2, PsiElement var3) throws IncorrectOperationException;

    @Override
    public final boolean isAvailable(Project project, Editor editor, PsiFile file) {
        if (file == null) {
            return false;
        }
        PsiManager manager = file.getManager();
        if (manager == null) {
            return false;
        }
        if (!manager.isInProject(file)) {
            return false;
        }
        PsiElement element = SuppressIntentionAction.getElement(editor, file);
        return element != null && this.isAvailable(project, editor, element);
    }

    public abstract boolean isAvailable(Project var1, Editor var2, PsiElement var3);

    private static PsiElement getElement(Editor editor, PsiFile file) {
        CaretModel caretModel = editor.getCaretModel();
        int position = caretModel.getOffset();
        return file.findElementAt(position);
    }
}

