/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.BatchSuppressableTool;
import com.intellij.codeInspection.DefaultXmlSuppressionProvider;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.XmlSuppressionProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;

public abstract class XmlSuppressableInspectionTool
extends LocalInspectionTool
implements BatchSuppressableTool {
    @NonNls
    static final String ALL = "ALL";

    public static SuppressQuickFix[] getSuppressFixes(String shortName) {
        return XmlSuppressableInspectionTool.getSuppressFixes(shortName, new DefaultXmlSuppressionProvider());
    }

    public static SuppressQuickFix[] getSuppressFixes(String shortName, XmlSuppressionProvider provider) {
        HighlightDisplayKey key = HighlightDisplayKey.find(shortName);
        if (key == null) {
            return SuppressQuickFix.EMPTY_ARRAY;
        }
        String id = key.getID();
        return new SuppressQuickFix[]{new SuppressTagStatic(id, provider), new SuppressForFile(id, provider), new SuppressAllForFile(provider)};
    }

    public static class SuppressAllForFile
    extends SuppressForFile {
        public SuppressAllForFile(XmlSuppressionProvider provider) {
            super(XmlSuppressableInspectionTool.ALL, provider);
        }

        public SuppressAllForFile() {
            super(XmlSuppressableInspectionTool.ALL);
        }

        @Override
        public String getName() {
            return InspectionsBundle.message("xml.suppressable.all.for.file.title", new Object[0]);
        }
    }

    public static class SuppressForFile
    extends XmlSuppressFix {
        public SuppressForFile(String inspectionId, XmlSuppressionProvider suppressionProvider) {
            super(inspectionId, suppressionProvider);
        }

        public SuppressForFile(String id) {
            super(id);
        }

        @Override
        public String getName() {
            return InspectionsBundle.message("xml.suppressable.for.file.title", new Object[0]);
        }

        @Override
        public void applyFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element == null || !element.isValid() || !(element.getContainingFile() instanceof XmlFile)) {
                return;
            }
            this.myProvider.suppressForFile(element, this.myId);
        }
    }

    public static class SuppressTagStatic
    extends XmlSuppressFix {
        public SuppressTagStatic(String inspectionId, XmlSuppressionProvider suppressionProvider) {
            super(inspectionId, suppressionProvider);
        }

        public SuppressTagStatic(String id) {
            super(id);
        }

        @Override
        public String getName() {
            return InspectionsBundle.message("xml.suppressable.for.tag.title", new Object[0]);
        }

        @Override
        public void applyFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (PsiTreeUtil.getParentOfType(element, XmlTag.class) == null) {
                return;
            }
            this.myProvider.suppressForTag(element, this.myId);
        }
    }

    public static abstract class XmlSuppressFix
    implements SuppressQuickFix {
        protected final String myId;
        protected final XmlSuppressionProvider myProvider;

        protected XmlSuppressFix(String inspectionId, XmlSuppressionProvider suppressionProvider) {
            this.myId = inspectionId;
            this.myProvider = suppressionProvider;
        }

        protected XmlSuppressFix(String id) {
            this(id, new DefaultXmlSuppressionProvider());
        }

        @Override
        public boolean isAvailable(Project project, PsiElement context) {
            return context.isValid();
        }

        @Override
        public String getFamilyName() {
            return this.getName();
        }
    }
}

