/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;

public abstract class XmlSuppressionProvider
implements InspectionSuppressor {
    public static final ExtensionPointName<XmlSuppressionProvider> EP_NAME = new ExtensionPointName("com.intellij.xml.xmlSuppressionProvider");

    public static boolean isSuppressed(PsiElement element, String inspectionId) {
        for (XmlSuppressionProvider provider : (XmlSuppressionProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!provider.isProviderAvailable(element.getContainingFile()) || !provider.isSuppressedFor(element, inspectionId)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean isProviderAvailable(PsiFile var1);

    @Override
    public abstract boolean isSuppressedFor(PsiElement var1, String var2);

    public abstract void suppressForFile(PsiElement var1, String var2);

    public abstract void suppressForTag(PsiElement var1, String var2);

    @Override
    public SuppressQuickFix[] getSuppressActions(PsiElement element, String toolShortName) {
        return XmlSuppressableInspectionTool.getSuppressFixes(toolShortName, this);
    }
}

