/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.util.ReflectionUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;

public class SingleCheckboxOptionsPanel
extends JPanel {
    public SingleCheckboxOptionsPanel(String label, InspectionProfileEntry owner, @NonNls String property) {
        super(new GridBagLayout());
        boolean selected = SingleCheckboxOptionsPanel.getPropertyValue(owner, property);
        JCheckBox checkBox = new JCheckBox(label, selected);
        ButtonModel model = checkBox.getModel();
        SingleCheckboxChangeListener listener = new SingleCheckboxChangeListener(owner, property, model);
        model.addChangeListener(listener);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 23;
        constraints.fill = 2;
        this.add((Component)checkBox, constraints);
    }

    private static boolean getPropertyValue(InspectionProfileEntry owner, String property) {
        return (Boolean)ReflectionUtil.getField(owner.getClass(), (Object)owner, Boolean.TYPE, (String)property);
    }

    private static class SingleCheckboxChangeListener
    implements ChangeListener {
        private final InspectionProfileEntry owner;
        private final String property;
        private final ButtonModel model;

        SingleCheckboxChangeListener(InspectionProfileEntry owner, String property, ButtonModel model) {
            this.owner = owner;
            this.property = property;
            this.model = model;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SingleCheckboxChangeListener.setPropertyValue(this.owner, this.property, this.model.isSelected());
        }

        private static void setPropertyValue(InspectionProfileEntry owner, String property, boolean selected) {
            ReflectionUtil.setField(owner.getClass(), (Object)owner, Boolean.TYPE, (String)property, (Object)selected);
        }
    }
}

