/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.openapi.module.Module;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ModuleSourceSet {
    private final Module myModule;
    private final Type myType;

    public ModuleSourceSet(Module module, Type type) {
        this.myModule = module;
        this.myType = type;
    }

    public Module getModule() {
        return this.myModule;
    }

    public Type getType() {
        return this.myType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleSourceSet set = (ModuleSourceSet)o;
        return this.myModule.equals(set.myModule) && this.myType == set.myType;
    }

    public int hashCode() {
        return 31 * this.myModule.hashCode() + this.myType.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return (this.myType == Type.PRODUCTION ? "" : "Tests of ") + "'" + this.myModule.getName() + "' module";
    }

    public static Set<Module> getModules(Collection<ModuleSourceSet> sourceSets) {
        HashSet<Module> modules = new HashSet<Module>();
        for (ModuleSourceSet set : sourceSets) {
            modules.add(set.getModule());
        }
        return modules;
    }

    public static enum Type {
        PRODUCTION,
        TEST;

    }
}

