/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerEncodingService;
import com.intellij.compiler.ant.ChunkCustomCompilerExtension;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;

public class ModuleChunk {
    private final Module[] myModules;
    private final ChunkCustomCompilerExtension[] myCustomCompilers;
    private Module myMainModule;
    private ModuleChunk[] myDependentChunks;
    private File myBaseDir = null;

    public ModuleChunk(Module[] modules) {
        this.myModules = modules;
        Arrays.sort(this.myModules, new Comparator<Module>(){

            @Override
            public int compare(Module o1, Module o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.myMainModule = this.myModules[0];
        this.myCustomCompilers = ChunkCustomCompilerExtension.getCustomCompile(this);
    }

    public String getName() {
        return this.myMainModule.getName();
    }

    public ChunkCustomCompilerExtension[] getCustomCompilers() {
        return this.myCustomCompilers;
    }

    public Module[] getModules() {
        return this.myModules;
    }

    public String getOutputDirUrl() {
        return CompilerModuleExtension.getInstance(this.myMainModule).getCompilerOutputUrl();
    }

    public String getTestsOutputDirUrl() {
        return CompilerModuleExtension.getInstance(this.myMainModule).getCompilerOutputUrlForTests();
    }

    public boolean isJdkInherited() {
        return ModuleRootManager.getInstance(this.myMainModule).isSdkInherited();
    }

    public Sdk getJdk() {
        return ModuleRootManager.getInstance(this.myMainModule).getSdk();
    }

    public ModuleChunk[] getDependentChunks() {
        return this.myDependentChunks;
    }

    public void setDependentChunks(ModuleChunk[] dependentChunks) {
        this.myDependentChunks = dependentChunks;
    }

    public File getBaseDir() {
        if (this.myBaseDir != null) {
            return this.myBaseDir;
        }
        return new File(this.myMainModule.getModuleFilePath()).getParentFile();
    }

    public void setBaseDir(File baseDir) {
        this.myBaseDir = baseDir;
    }

    public void setMainModule(Module module) {
        this.myMainModule = module;
    }

    public Project getProject() {
        return this.myMainModule.getProject();
    }

    public String getChunkSpecificCompileOptions() {
        StringBuilder options = new StringBuilder();
        Charset encoding = CompilerEncodingService.getInstance(this.getProject()).getPreferredModuleEncoding(this.myMainModule);
        if (encoding != null) {
            ModuleChunk.appendOption(options, "-encoding", encoding.name());
        }
        ModuleChunk.appendOption(options, "-source", ModuleChunk.getLanguageLevelOption(ApplicationManager.getApplication().runReadAction(new Computable<LanguageLevel>(){

            public LanguageLevel compute() {
                return EffectiveLanguageLevelUtil.getEffectiveLanguageLevel(ModuleChunk.this.myMainModule);
            }
        })));
        ModuleChunk.appendOption(options, "-target", CompilerConfiguration.getInstance(this.getProject()).getBytecodeTargetLevel(this.myMainModule));
        return options.toString();
    }

    public boolean contains(Module module) {
        for (Module chunkModule : this.myModules) {
            if (!chunkModule.equals(module)) continue;
            return true;
        }
        return false;
    }

    private static void appendOption(StringBuilder options, String name, String value) {
        if (!StringUtil.isEmpty((String)value)) {
            if (options.length() > 0) {
                options.append(" ");
            }
            options.append(name).append(" ").append(value);
        }
    }

    private static String getLanguageLevelOption(LanguageLevel level) {
        if (level != null) {
            switch (level) {
                case JDK_1_3: {
                    return "1.3";
                }
                case JDK_1_4: {
                    return "1.4";
                }
                case JDK_1_5: {
                    return "1.5";
                }
                case JDK_1_6: {
                    return "1.6";
                }
                case JDK_1_7: {
                    return "1.7";
                }
                case JDK_1_8: {
                    return "8";
                }
                case JDK_1_9: {
                    return "9";
                }
            }
        }
        return null;
    }
}

