/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.CommonBundle;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.PropertyKey;

public class DebuggerBundle {
    private static Reference<ResourceBundle> ourBundle;
    @NonNls
    private static final String BUNDLE = "messages.DebuggerBundle";

    public static String message(@PropertyKey(resourceBundle="messages.DebuggerBundle") String key, Object ... params) {
        return CommonBundle.message((ResourceBundle)DebuggerBundle.getBundle(), (String)key, (Object[])params);
    }

    private DebuggerBundle() {
    }

    public static String getAddressDisplayName(RemoteConnection connection) {
        return connection.isUseSockets() ? connection.getHostName() + ":" + connection.getAddress() : connection.getAddress();
    }

    public static String getTransportName(RemoteConnection connection) {
        return connection.isUseSockets() ? DebuggerBundle.message("transport.name.socket", new Object[0]) : DebuggerBundle.message("transport.name.shared.memory", new Object[0]);
    }

    private static ResourceBundle getBundle() {
        ResourceBundle bundle = (ResourceBundle)SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE);
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }
}

