/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.ExecutionWithDebuggerToolsTestCase;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.RemoteStateState;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.impl.InvokeThread;
import com.intellij.debugger.impl.SynchronizationBasedSemaphore;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineBuilder;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.sun.jdi.Value;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;
import javax.swing.Icon;
import junit.framework.TestCase;
import org.jdom.Element;

public abstract class DebuggerTestCase
extends ExecutionWithDebuggerToolsTestCase {
    protected DebuggerSession myDebuggerSession;
    private StringBuffer myConsoleBuffer;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void initApplication() throws Exception {
        super.initApplication();
        this.setTestJDK();
        DebuggerSettings.getInstance().DEBUGGER_TRANSPORT = 0;
        DebuggerSettings.getInstance().SKIP_CONSTRUCTORS = false;
        DebuggerSettings.getInstance().SKIP_GETTERS = false;
        NodeRendererSettings.getInstance().getClassRenderer().SHOW_DECLARED_TYPE = true;
    }

    @Override
    protected void runTest() throws Throwable {
        super.runTest();
        if (this.getDebugProcess() != null) {
            this.getDebugProcess().getProcessHandler().startNotify();
            this.waitProcess(this.getDebugProcess().getProcessHandler());
            this.waitForCompleted();
            DebuggerTestCase.assertNull((Object)DebuggerManagerEx.getInstanceEx((Project)this.myProject).getDebugProcess(this.getDebugProcess().getProcessHandler()));
            this.myDebuggerSession = null;
        }
        if (this.myConsoleBuffer != null) {
            // empty if block
        }
        this.checkTestOutput();
    }

    protected void checkTestOutput() throws Exception {
        this.getChecker().checkValid(this.getTestProjectJdk());
    }

    protected void disposeSession(final DebuggerSession debuggerSession) throws InterruptedException, InvocationTargetException {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                debuggerSession.dispose();
            }
        });
    }

    @Override
    protected void tearDown() throws Exception {
        FileEditorManagerEx.getInstanceEx((Project)this.getProject()).closeAllFiles();
        this.myConsoleBuffer = null;
        super.tearDown();
    }

    protected void createLocalProcess(String className) throws ExecutionException, InterruptedException, InvocationTargetException {
        LOG.assertTrue(this.myDebugProcess == null);
        this.myDebuggerSession = this.createLocalProcess(0, this.createJavaParameters(className));
        this.myDebugProcess = this.myDebuggerSession.getProcess();
    }

    protected DebuggerSession createLocalSession(final JavaParameters javaParameters) throws ExecutionException, InterruptedException {
        this.createBreakpoints(javaParameters.getMainClass());
        DebuggerSettings.getInstance().DEBUGGER_TRANSPORT = 0;
        GenericDebuggerRunnerSettings debuggerRunnerSettings = new GenericDebuggerRunnerSettings();
        debuggerRunnerSettings.LOCAL = true;
        final RemoteConnection debugParameters = DebuggerManagerImpl.createDebugParameters((JavaParameters)javaParameters, (GenericDebuggerRunnerSettings)debuggerRunnerSettings, (boolean)false);
        ExecutionEnvironment environment = new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runnerSettings((RunnerSettings)debuggerRunnerSettings).runProfile(new MockConfiguration()).build();
        final JavaCommandLineState javaCommandLineState = new JavaCommandLineState(environment){

            @Override
            protected JavaParameters createJavaParameters() {
                return javaParameters;
            }

            @Override
            protected GeneralCommandLine createCommandLine() throws ExecutionException {
                return CommandLineBuilder.createFromJavaParameters(this.getJavaParameters());
            }
        };
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    DebuggerTestCase.this.myDebuggerSession = DebuggerManagerEx.getInstanceEx((Project)DebuggerTestCase.this.myProject).attachVirtualMachine((DebugEnvironment)new DefaultDebugEnvironment(new ExecutionEnvironmentBuilder(DebuggerTestCase.this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runProfile(new MockConfiguration()).build(), (RunProfileState)javaCommandLineState, debugParameters, false));
                    XDebuggerManager.getInstance(DebuggerTestCase.this.myProject).startSession(javaCommandLineState.getEnvironment(), new XDebugProcessStarter(){

                        @Override
                        public XDebugProcess start(XDebugSession session) {
                            return JavaDebugProcess.create((XDebugSession)session, (DebuggerSession)DebuggerTestCase.this.myDebuggerSession);
                        }
                    });
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                }
            }
        }, ModalityState.defaultModalityState());
        this.myDebugProcess = this.myDebuggerSession.getProcess();
        this.myDebugProcess.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                DebuggerTestCase.this.print(event.getText(), outputType);
            }
        });
        DebuggerTestCase.assertNotNull((Object)this.myDebuggerSession);
        DebuggerTestCase.assertNotNull((Object)this.myDebugProcess);
        return this.myDebuggerSession;
    }

    protected DebuggerSession createLocalProcess(int transport, final JavaParameters javaParameters) throws ExecutionException, InterruptedException, InvocationTargetException {
        this.createBreakpoints(javaParameters.getMainClass());
        final DebuggerSession[] debuggerSession = new DebuggerSession[]{null};
        DebuggerSettings.getInstance().DEBUGGER_TRANSPORT = transport;
        GenericDebuggerRunnerSettings debuggerRunnerSettings = new GenericDebuggerRunnerSettings();
        debuggerRunnerSettings.LOCAL = true;
        debuggerRunnerSettings.setDebugPort("3456");
        ExecutionEnvironment environment = new ExecutionEnvironmentBuilder(this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runnerSettings((RunnerSettings)debuggerRunnerSettings).runProfile(new MockConfiguration()).build();
        final JavaCommandLineState javaCommandLineState = new JavaCommandLineState(environment){

            @Override
            protected JavaParameters createJavaParameters() {
                return javaParameters;
            }

            @Override
            protected GeneralCommandLine createCommandLine() throws ExecutionException {
                return CommandLineBuilder.createFromJavaParameters(this.getJavaParameters());
            }
        };
        final RemoteConnection debugParameters = DebuggerManagerImpl.createDebugParameters((JavaParameters)javaCommandLineState.getJavaParameters(), (GenericDebuggerRunnerSettings)debuggerRunnerSettings, (boolean)true);
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    debuggerSession[0] = DebuggerTestCase.this.attachVirtualMachine(javaCommandLineState, javaCommandLineState.getEnvironment(), debugParameters, false);
                }
                catch (ExecutionException e) {
                    TestCase.fail((String)e.getMessage());
                }
            }
        });
        ProcessHandler processHandler = debuggerSession[0].getProcess().getProcessHandler();
        debuggerSession[0].getProcess().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                DebuggerTestCase.this.print(event.getText(), outputType);
            }
        });
        DebugProcessImpl process = (DebugProcessImpl)DebuggerManagerEx.getInstanceEx((Project)this.myProject).getDebugProcess(processHandler);
        DebuggerTestCase.assertNotNull((Object)process);
        return debuggerSession[0];
    }

    protected DebuggerSession createRemoteProcess(int transport, boolean serverMode, JavaParameters javaParameters) throws ExecutionException, InterruptedException, InvocationTargetException {
        DebuggerSession debuggerSession;
        boolean useSockets = transport == 0;
        RemoteConnection remoteConnection = new RemoteConnection(useSockets, "127.0.0.1", "3456", serverMode);
        String launchCommandLine = remoteConnection.getLaunchCommandLine();
        launchCommandLine = StringUtil.replace((String)launchCommandLine, (String)",onthrow=<FQ exception class name>", (String)"");
        launchCommandLine = StringUtil.replace((String)launchCommandLine, (String)",onuncaught=<y/n>", (String)"");
        launchCommandLine = StringUtil.replace((String)launchCommandLine, (String)"suspend=n", (String)"suspend=y");
        this.println(launchCommandLine, ProcessOutputTypes.SYSTEM);
        StringTokenizer tokenizer = new StringTokenizer(launchCommandLine);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            javaParameters.getVMParametersList().add(token);
        }
        GeneralCommandLine commandLine = CommandLineBuilder.createFromJavaParameters(javaParameters);
        if (serverMode) {
            debuggerSession = this.attachVM(remoteConnection, false);
            commandLine.createProcess();
        } else {
            commandLine.createProcess();
            debuggerSession = this.attachVM(remoteConnection, true);
        }
        ProcessHandler processHandler = debuggerSession.getProcess().getProcessHandler();
        DebugProcessImpl process = (DebugProcessImpl)DebuggerManagerEx.getInstanceEx((Project)this.myProject).getDebugProcess(processHandler);
        DebuggerTestCase.assertNotNull((Object)process);
        return debuggerSession;
    }

    protected DebuggerSession attachVM(RemoteConnection remoteConnection, boolean pollConnection) throws InvocationTargetException, InterruptedException {
        RemoteStateState remoteState = new RemoteStateState(this.myProject, remoteConnection);
        final DebuggerSession[] debuggerSession = new DebuggerSession[1];
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable((RemoteState)remoteState, remoteConnection, pollConnection){
            final /* synthetic */ RemoteState val$remoteState;
            final /* synthetic */ RemoteConnection val$remoteConnection;
            final /* synthetic */ boolean val$pollConnection;
            {
                this.val$remoteState = remoteState;
                this.val$remoteConnection = remoteConnection;
                this.val$pollConnection = bl;
            }

            @Override
            public void run() {
                try {
                    debuggerSession[0] = DebuggerTestCase.this.attachVirtualMachine(this.val$remoteState, new ExecutionEnvironmentBuilder(DebuggerTestCase.this.myProject, DefaultDebugExecutor.getDebugExecutorInstance()).runProfile(new MockConfiguration()).build(), this.val$remoteConnection, this.val$pollConnection);
                }
                catch (ExecutionException e) {
                    TestCase.fail((String)e.getMessage());
                }
            }
        });
        debuggerSession[0].getProcess().getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                DebuggerTestCase.this.print(event.getText(), outputType);
            }
        });
        return debuggerSession[0];
    }

    protected void createBreakpoints(final String className) {
        PsiFile psiFile = ApplicationManager.getApplication().runReadAction(new Computable<PsiFile>(){

            public PsiFile compute() {
                PsiClass psiClass = JavaPsiFacade.getInstance(DebuggerTestCase.this.myProject).findClass(className, GlobalSearchScope.allScope(DebuggerTestCase.this.myProject));
                return psiClass.getContainingFile();
            }
        });
        this.createBreakpoints(psiFile);
    }

    protected EvaluationContextImpl createEvaluationContext(SuspendContextImpl suspendContext) {
        try {
            return new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy(), (Value)suspendContext.getFrameProxy().thisObject());
        }
        catch (EvaluateException e) {
            this.error(e);
            return null;
        }
    }

    protected void waitForCompleted() {
        final SynchronizationBasedSemaphore s = new SynchronizationBasedSemaphore();
        s.down();
        final InvokeThread.WorkerThreadRequest request = this.getDebugProcess().getManagerThread().getCurrentRequest();
        final Thread thread = new Thread("Joining " + request){

            @Override
            public void run() {
                try {
                    request.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
        if (request.isDone()) {
            thread.interrupt();
        }
        this.waitFor(new Runnable(){

            @Override
            public void run() {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.invokeRatherLater(new DebuggerCommandImpl(){

            protected void action() throws Exception {
                LOG.assertTrue(false);
            }

            protected void commandCancelled() {
                DebuggerTestCase.this.invokeRatherLater(new DebuggerCommandImpl(){

                    protected void action() throws Exception {
                        LOG.assertTrue(false);
                    }

                    protected void commandCancelled() {
                        s.up();
                    }
                });
            }
        });
        this.waitFor(new Runnable(){

            @Override
            public void run() {
                s.waitFor();
            }
        });
    }

    public DebuggerContextImpl createDebuggerContext(final SuspendContextImpl suspendContext, StackFrameProxyImpl stackFrame) {
        final DebuggerSession[] session = new DebuggerSession[1];
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                session[0] = DebuggerManagerEx.getInstanceEx((Project)DebuggerTestCase.this.myProject).getSession((DebugProcess)suspendContext.getDebugProcess());
            }
        });
        DebuggerContextImpl debuggerContext = DebuggerContextImpl.createDebuggerContext((DebuggerSession)session[0], (SuspendContextImpl)suspendContext, (ThreadReferenceProxyImpl)(stackFrame != null ? stackFrame.threadProxy() : null), (StackFrameProxyImpl)stackFrame);
        debuggerContext.initCaches();
        return debuggerContext;
    }

    public DebuggerContextImpl createDebuggerContext(SuspendContextImpl suspendContext) {
        return this.createDebuggerContext(suspendContext, suspendContext.getFrameProxy());
    }

    protected void createBreakpointInHelloWorld() {
        DebuggerInvocationUtil.invokeAndWait((Project)this.myProject, (Runnable)new Runnable(){

            @Override
            public void run() {
                BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx((Project)DebuggerTestCase.this.myProject).getBreakpointManager();
                PsiClass psiClass = JavaPsiFacade.getInstance(DebuggerTestCase.this.myProject).findClass("HelloWorld", GlobalSearchScope.allScope(DebuggerTestCase.this.myProject));
                Document document = PsiDocumentManager.getInstance(DebuggerTestCase.this.myProject).getDocument(psiClass.getContainingFile());
                breakpointManager.addLineBreakpoint(document, 3);
            }
        }, (ModalityState)ApplicationManager.getApplication().getDefaultModalityState());
    }

    protected void createHelloWorldProcessWithBreakpoint() throws ExecutionException, InterruptedException, InvocationTargetException {
        this.createLocalProcess("HelloWorld");
        this.createBreakpointInHelloWorld();
    }

    @Override
    protected DebugProcessImpl getDebugProcess() {
        return this.myDebuggerSession != null ? this.myDebuggerSession.getProcess() : null;
    }

    public DebuggerSession getDebuggerSession() {
        return this.myDebuggerSession;
    }

    protected DebuggerSession attachVirtualMachine(RunProfileState state, ExecutionEnvironment environment, RemoteConnection remoteConnection, boolean pollConnection) throws ExecutionException {
        final DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx((Project)this.myProject).attachVirtualMachine((DebugEnvironment)new DefaultDebugEnvironment(environment, state, remoteConnection, pollConnection));
        XDebuggerManager.getInstance(this.myProject).startSession(environment, new XDebugProcessStarter(){

            @Override
            public XDebugProcess start(XDebugSession session) {
                return JavaDebugProcess.create((XDebugSession)session, (DebuggerSession)debuggerSession);
            }
        });
        return debuggerSession;
    }

    public static class MockConfiguration
    implements ModuleRunConfiguration {
        @Override
        public Module[] getModules() {
            return Module.EMPTY_ARRAY;
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public ConfigurationFactory getFactory() {
            return null;
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            return null;
        }

        @Override
        public Project getProject() {
            return null;
        }

        @Override
        public ConfigurationType getType() {
            return UnknownConfigurationType.INSTANCE;
        }

        @Override
        public ConfigurationPerRunnerSettings createRunnerSettings(ConfigurationInfoProvider provider) {
            return null;
        }

        @Override
        public SettingsEditor<ConfigurationPerRunnerSettings> getRunnerSettingsEditor(ProgramRunner runner) {
            return null;
        }

        @Override
        public RunConfiguration clone() {
            return null;
        }

        @Override
        public int getUniqueID() {
            return 0;
        }

        @Override
        public RunProfileState getState(Executor executor, ExecutionEnvironment env) throws ExecutionException {
            return null;
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public void checkConfiguration() throws RuntimeConfigurationException {
        }

        public void readExternal(Element element) throws InvalidDataException {
        }

        public void writeExternal(Element element) throws WriteExternalException {
        }
    }
}

