/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.SourcesFinder;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public abstract class JSR45PositionManager<Scope>
implements PositionManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.JSR45PositionManager");
    protected final DebugProcess myDebugProcess;
    protected final Scope myScope;
    private final String myStratumId;
    protected final SourcesFinder<Scope> mySourcesFinder;
    protected final String GENERATED_CLASS_PATTERN;
    protected Matcher myGeneratedClassPatternMatcher;
    private final Set<LanguageFileType> myFileTypes;

    public JSR45PositionManager(DebugProcess debugProcess, Scope scope, String stratumId, LanguageFileType[] acceptedFileTypes, SourcesFinder<Scope> sourcesFinder) {
        this.myDebugProcess = debugProcess;
        this.myScope = scope;
        this.myStratumId = stratumId;
        this.myFileTypes = Collections.unmodifiableSet(new HashSet<LanguageFileType>(Arrays.asList(acceptedFileTypes)));
        this.mySourcesFinder = sourcesFinder;
        String generatedClassPattern = this.getGeneratedClassesPackage();
        generatedClassPattern = generatedClassPattern.length() == 0 ? this.getGeneratedClassesNamePattern() : generatedClassPattern + "." + this.getGeneratedClassesNamePattern();
        this.GENERATED_CLASS_PATTERN = generatedClassPattern;
        this.myGeneratedClassPatternMatcher = Pattern.compile(generatedClassPattern.replaceAll("\\*", ".*")).matcher("");
    }

    @NonNls
    protected abstract String getGeneratedClassesPackage();

    protected String getGeneratedClassesNamePattern() {
        return "*";
    }

    public final String getStratumId() {
        return this.myStratumId;
    }

    @Override
    public SourcePosition getSourcePosition(Location location) throws NoDataException {
        SourcePosition sourcePosition = null;
        try {
            String sourcePath = this.getRelativeSourcePathByLocation(location);
            PsiFile file = this.mySourcesFinder.findSourceFile(sourcePath, this.myDebugProcess.getProject(), this.myScope);
            if (file != null) {
                int lineNumber = this.getLineNumber(location);
                sourcePosition = SourcePosition.createFromLine(file, lineNumber - 1);
            }
        }
        catch (AbsentInformationException ignored) {
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        if (sourcePosition == null) {
            throw NoDataException.INSTANCE;
        }
        return sourcePosition;
    }

    protected String getRelativeSourcePathByLocation(Location location) throws AbsentInformationException {
        return this.getRelativePath(location.sourcePath(this.myStratumId));
    }

    protected int getLineNumber(Location location) {
        return location.lineNumber(this.myStratumId);
    }

    @Override
    public List<ReferenceType> getAllClasses(SourcePosition classPosition) throws NoDataException {
        this.checkSourcePositionFileType(classPosition);
        List<ReferenceType> referenceTypes = this.myDebugProcess.getVirtualMachineProxy().allClasses();
        ArrayList<ReferenceType> result = new ArrayList<ReferenceType>();
        for (ReferenceType referenceType : referenceTypes) {
            List<Location> locations;
            this.myGeneratedClassPatternMatcher.reset(referenceType.name());
            if (!this.myGeneratedClassPatternMatcher.matches() || (locations = this.locationsOfClassAt(referenceType, classPosition)) == null || locations.size() <= 0) continue;
            result.add(referenceType);
        }
        return result;
    }

    private void checkSourcePositionFileType(SourcePosition classPosition) throws NoDataException {
        FileType fileType = classPosition.getFile().getFileType();
        if (!this.myFileTypes.contains(fileType)) {
            throw NoDataException.INSTANCE;
        }
    }

    @Override
    public List<Location> locationsOfLine(ReferenceType type, SourcePosition position) throws NoDataException {
        List<Location> locations = this.locationsOfClassAt(type, position);
        return locations != null ? locations : Collections.emptyList();
    }

    private List<Location> locationsOfClassAt(final ReferenceType type, final SourcePosition position) throws NoDataException {
        this.checkSourcePositionFileType(position);
        return ApplicationManager.getApplication().runReadAction(new Computable<List<Location>>(){

            public List<Location> compute() {
                try {
                    List<String> relativePaths = JSR45PositionManager.this.getRelativeSourePathsByType(type);
                    for (String relativePath : relativePaths) {
                        PsiFile file = JSR45PositionManager.this.mySourcesFinder.findSourceFile(relativePath, JSR45PositionManager.this.myDebugProcess.getProject(), JSR45PositionManager.this.myScope);
                        if (file == null || !file.equals(position.getFile())) continue;
                        return JSR45PositionManager.this.getLocationsOfLine(type, this.getSourceName(file.getName(), type), relativePath, position.getLine() + 1);
                    }
                }
                catch (ObjectCollectedException ignored) {
                }
                catch (AbsentInformationException ignored) {
                }
                catch (ClassNotPreparedException ignored) {
                }
                catch (InternalError ignored) {
                    JSR45PositionManager.this.myDebugProcess.printToConsole(DebuggerBundle.message("internal.error.locations.of.line", type.name()));
                }
                return null;
            }

            private String getSourceName(String name, ReferenceType type2) throws AbsentInformationException {
                for (String sourceNameFromType : type2.sourceNames(JSR45PositionManager.this.myStratumId)) {
                    if (!sourceNameFromType.contains(name)) continue;
                    return sourceNameFromType;
                }
                return name;
            }
        });
    }

    protected List<String> getRelativeSourePathsByType(ReferenceType type) throws AbsentInformationException {
        List<String> paths = type.sourcePaths(this.myStratumId);
        ArrayList<String> relativePaths = new ArrayList<String>();
        for (String path : paths) {
            relativePaths.add(this.getRelativePath(path));
        }
        return relativePaths;
    }

    protected List<Location> getLocationsOfLine(ReferenceType type, String fileName, String relativePath, int lineNumber) throws AbsentInformationException {
        return type.locationsOfLine(this.myStratumId, fileName, lineNumber);
    }

    @Override
    public ClassPrepareRequest createPrepareRequest(final ClassPrepareRequestor requestor, final SourcePosition position) throws NoDataException {
        this.checkSourcePositionFileType(position);
        return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(new ClassPrepareRequestor(){

            @Override
            public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                JSR45PositionManager.this.onClassPrepare(debuggerProcess, referenceType, position, requestor);
            }
        }, this.GENERATED_CLASS_PATTERN);
    }

    protected void onClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType, SourcePosition position, ClassPrepareRequestor requestor) {
        try {
            if (this.locationsOfClassAt(referenceType, position) != null) {
                requestor.processClassPrepare(debuggerProcess, referenceType);
            }
        }
        catch (NoDataException ignored) {
            // empty catch block
        }
    }

    protected String getRelativePath(String sourcePath) {
        String generatedClassesPackage;
        String prefix;
        if (sourcePath != null && (sourcePath = sourcePath.trim()).startsWith(prefix = (generatedClassesPackage = this.getGeneratedClassesPackage()).replace('.', File.separatorChar)) && (sourcePath = sourcePath.substring(prefix.length())).startsWith(File.separator)) {
            sourcePath = sourcePath.substring(1);
        }
        return sourcePath;
    }
}

