/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;

public abstract class ExecutionManager {
    public static final Topic<ExecutionListener> EXECUTION_TOPIC = Topic.create((String)"configuration executed", ExecutionListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);

    public static ExecutionManager getInstance(Project project) {
        return ServiceManager.getService(project, ExecutionManager.class);
    }

    public abstract RunContentManager getContentManager();

    public abstract void compileAndRun(Runnable var1, ExecutionEnvironment var2, RunProfileState var3, Runnable var4);

    public abstract ProcessHandler[] getRunningProcesses();

    public abstract void startRunProfile(RunProfileStarter var1, RunProfileState var2, ExecutionEnvironment var3);

    public abstract void restartRunProfile(Project var1, Executor var2, ExecutionTarget var3, RunnerAndConfigurationSettings var4, ProcessHandler var5);

    public abstract void restartRunProfile(Project var1, Executor var2, ExecutionTarget var3, RunnerAndConfigurationSettings var4, RunContentDescriptor var5);

    public abstract void restartRunProfile(ProgramRunner var1, ExecutionEnvironment var2, RunContentDescriptor var3);

    public abstract void restartRunProfile(ExecutionEnvironment var1);
}

