/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import java.util.Collections;
import java.util.List;

public abstract class ExecutionTargetManager {
    public static final Topic<ExecutionTargetListener> TOPIC = Topic.create((String)"ExecutionTarget topic", ExecutionTargetListener.class);

    public static ExecutionTargetManager getInstance(Project project) {
        return ServiceManager.getService(project, ExecutionTargetManager.class);
    }

    public static ExecutionTarget getActiveTarget(Project project) {
        return ExecutionTargetManager.getInstance(project).getActiveTarget();
    }

    public static void setActiveTarget(Project project, ExecutionTarget target) {
        ExecutionTargetManager.getInstance(project).setActiveTarget(target);
    }

    public static List<ExecutionTarget> getTargetsFor(Project project, RunnerAndConfigurationSettings settings) {
        return ExecutionTargetManager.getInstance(project).getTargetsFor(settings);
    }

    public static List<ExecutionTarget> getTargetsToChooseFor(Project project, RunnerAndConfigurationSettings settings) {
        List<ExecutionTarget> result = ExecutionTargetManager.getInstance(project).getTargetsFor(settings);
        if (result.size() == 1 && DefaultExecutionTarget.INSTANCE.equals(result.get(0))) {
            return Collections.emptyList();
        }
        return result;
    }

    public static boolean canRun(RunnerAndConfigurationSettings settings, ExecutionTarget target) {
        return settings != null && target != null && settings.canRunOn(target) && target.canRun(settings);
    }

    public static boolean canRun(ExecutionEnvironment environment) {
        return ExecutionTargetManager.canRun(environment.getRunnerAndConfigurationSettings(), environment.getExecutionTarget());
    }

    public static void update(Project project) {
        ExecutionTargetManager.getInstance(project).update();
    }

    public abstract ExecutionTarget getActiveTarget();

    public abstract void setActiveTarget(ExecutionTarget var1);

    public abstract List<ExecutionTarget> getTargetsFor(RunnerAndConfigurationSettings var1);

    public abstract void update();
}

