/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.debugger.impl.OutputChecker;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.IdeaTestCase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import com.sun.tools.javac.Main;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;

public abstract class ExecutionTestCase
extends IdeaTestCase {
    private OutputChecker myChecker;
    private int myTimeout;
    private static AssertionFailedError ourAssertion;
    private static final String CLASSES = "classes";
    private static final String SRC = "src";

    public ExecutionTestCase() {
        this.setTimeout(300000);
    }

    public void setTimeout(int timeout) {
        this.myTimeout = timeout;
    }

    protected abstract OutputChecker initOutputChecker();

    protected abstract String getTestAppPath();

    @Override
    protected void setUp() throws Exception {
        ourAssertion = null;
        this.ensureCompiledAppExists();
        this.myChecker = this.initOutputChecker();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ExecutionTestCase.super.setUp();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    TestCase.assertTrue((boolean)false);
                }
            }
        });
    }

    protected void setUpModule() {
        super.setUpModule();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                String modulePath = ExecutionTestCase.this.getTestAppPath();
                String srcPath = modulePath + File.separator + ExecutionTestCase.SRC;
                VirtualFile moduleDir = LocalFileSystem.getInstance().findFileByPath(modulePath.replace(File.separatorChar, '/'));
                VirtualFile srcDir = LocalFileSystem.getInstance().findFileByPath(srcPath.replace(File.separatorChar, '/'));
                ModuleRootManager rootManager = ModuleRootManager.getInstance(ExecutionTestCase.this.myModule);
                PsiTestUtil.removeAllRoots((Module)ExecutionTestCase.this.myModule, (Sdk)rootManager.getSdk());
                PsiTestUtil.addContentRoot((Module)ExecutionTestCase.this.myModule, (VirtualFile)moduleDir);
                PsiTestUtil.addSourceRoot((Module)ExecutionTestCase.this.myModule, (VirtualFile)srcDir);
                PsiTestUtil.setCompilerOutputPath((Module)ExecutionTestCase.this.myModule, (String)VfsUtilCore.pathToUrl(FileUtil.toSystemIndependentName((String)ExecutionTestCase.this.getAppClassesPath())), (boolean)false);
            }
        });
    }

    public void println(@NonNls String s, Key outputType) {
        this.myChecker.println(s, outputType);
    }

    public void print(String s, Key outputType) {
        this.myChecker.print(s, outputType);
    }

    protected void runBareRunnable(Runnable runnable) throws Throwable {
        runnable.run();
    }

    protected void runTest() throws Throwable {
        this.myChecker.init(this.getTestName(true));
        super.runTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ExecutionTestCase.super.tearDown();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        });
        if (ourAssertion != null) {
            throw ourAssertion;
        }
        ExecutionTestCase executionTestCase = this;
        synchronized (executionTestCase) {
            ((Object)((Object)this)).wait(300L);
        }
    }

    protected JavaParameters createJavaParameters(String mainClass) {
        JavaParameters parameters = new JavaParameters();
        parameters.getClassPath().add(this.getAppClassesPath());
        parameters.setMainClass(mainClass);
        parameters.setJdk(JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk());
        return parameters;
    }

    protected OutputChecker getChecker() {
        return this.myChecker;
    }

    protected String getAppDataPath() {
        return this.getTestAppPath() + File.separator + "data";
    }

    protected String getAppOptionsPath() {
        return this.getTestAppPath() + File.separator + "config" + File.separator + "options";
    }

    protected String getAppClassesPath() {
        return this.getTestAppPath() + File.separator + CLASSES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitProcess(final ProcessHandler processHandler) {
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, this.getTestRootDisposable());
        final boolean[] isRunning = new boolean[]{true};
        alarm.addRequest(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean[] blArray = isRunning;
                synchronized (isRunning) {
                    boolean b = isRunning[0];
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    if (b) {
                        processHandler.destroyProcess();
                        LOG.error("process was running over " + ExecutionTestCase.this.myTimeout / 1000 + " seconds. Interrupted. ");
                    }
                    return;
                }
            }
        }, this.myTimeout);
        processHandler.waitFor();
        boolean[] blArray = isRunning;
        synchronized (isRunning) {
            isRunning[0] = false;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            alarm.dispose();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(Runnable r) {
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, this.getTestRootDisposable());
        final Thread thread = Thread.currentThread();
        final boolean[] isRunning = new boolean[]{true};
        alarm.addRequest(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean[] blArray = isRunning;
                synchronized (isRunning) {
                    boolean b = isRunning[0];
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    if (b) {
                        thread.interrupt();
                        LOG.error("test was running over " + ExecutionTestCase.this.myTimeout / 1000 + " seconds. Interrupted. ");
                    }
                    return;
                }
            }
        }, this.myTimeout);
        r.run();
        boolean[] blArray = isRunning;
        synchronized (isRunning) {
            isRunning[0] = false;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            Thread.interrupted();
            return;
        }
    }

    protected int getTestAppVersion() {
        return 6;
    }

    protected void ensureCompiledAppExists() throws Exception {
        String appPath = this.getTestAppPath();
        File classesDir = new File(appPath, CLASSES);
        String VERSION_FILE_NAME = "version-" + this.getTestAppVersion();
        File versionFile = new File(classesDir, VERSION_FILE_NAME);
        if (!(classesDir.exists() && versionFile.exists() && this.hasCompiledClasses(classesDir))) {
            FileUtil.delete((File)classesDir);
            classesDir.mkdirs();
            if (this.compileTinyApp(appPath) != 0) {
                throw new Exception("Failed to compile debugger test application.\nIt must be compiled in order to run debugger tests.\n" + appPath);
            }
            versionFile.createNewFile();
        }
    }

    private int compileTinyApp(String appPath) {
        File[] files;
        ArrayList<String> args = new ArrayList<String>();
        args.add("-g");
        args.add("-d");
        args.add(new File(appPath, CLASSES).getPath());
        Class<TestCase> testCaseClass = TestCase.class;
        String junitLibRoot = PathManager.getResourceRoot(testCaseClass, (String)("/" + testCaseClass.getName().replace('.', '/') + ".class"));
        if (junitLibRoot != null) {
            args.add("-cp");
            args.add(junitLibRoot);
        }
        if ((files = new File(appPath, SRC).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".java");
            }
        })) == null) {
            return 0;
        }
        for (File file : files) {
            args.add(file.getPath());
        }
        return Main.compile(ArrayUtil.toStringArray(args));
    }

    private boolean hasCompiledClasses(File classesDir) {
        for (File file : classesDir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".class")) continue;
            return true;
        }
        return false;
    }
}

