/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.PsiLocation;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;

public abstract class Location<E extends PsiElement> {
    public static final DataKey<Location<?>> DATA_KEY = DataKey.create("Location");
    public static final DataKey<Location<?>[]> DATA_KEYS = DataKey.create("LocationArray");
    @Deprecated
    @NonNls
    public static final String LOCATION = DATA_KEY.getName();

    public abstract E getPsiElement();

    public abstract Project getProject();

    public abstract <T extends PsiElement> Iterator<Location<T>> getAncestors(Class<T> var1, boolean var2);

    public VirtualFile getVirtualFile() {
        E psiElement = this.getPsiElement();
        if (!psiElement.isValid()) {
            return null;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return virtualFile;
    }

    public OpenFileDescriptor getOpenFileDescriptor() {
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return new OpenFileDescriptor(this.getProject(), virtualFile, this.getPsiElement().getTextOffset());
    }

    public <Ancestor extends PsiElement> Location<Ancestor> getParent(Class<Ancestor> parentClass) {
        Iterator<Location<PsiElement>> ancestors = this.getAncestors(PsiElement.class, true);
        if (!ancestors.hasNext()) {
            return null;
        }
        Location<PsiElement> parent = ancestors.next();
        if (parentClass.isInstance(parent.getPsiElement())) {
            return parent;
        }
        return null;
    }

    public <T extends PsiElement> Location<T> getAncestorOrSelf(Class<T> ancestorClass) {
        Iterator<Location<T>> ancestors = this.getAncestors(ancestorClass, false);
        if (!ancestors.hasNext()) {
            return null;
        }
        return ancestors.next();
    }

    public <Ancestor extends PsiElement> Ancestor getParentElement(Class<Ancestor> parentClass) {
        return Location.safeGetPsiElement(this.getParent(parentClass));
    }

    public static <T extends PsiElement> T safeGetPsiElement(Location<T> location) {
        return location != null ? (T)location.getPsiElement() : null;
    }

    public static <T> T safeCast(Object obj, Class<T> expectedClass) {
        if (expectedClass.isInstance(obj)) {
            return (T)obj;
        }
        return null;
    }

    public PsiLocation<E> toPsiLocation() {
        return new PsiLocation<E>(this.getProject(), this.getPsiElement());
    }

    public abstract Module getModule();
}

