/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.configuration.RunConfigurationExtensionBase;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.jdom.Element;

public class RunConfigurationExtensionsManager<U extends RunConfigurationBase, T extends RunConfigurationExtensionBase<U>> {
    public static final Key<List<Element>> RUN_EXTENSIONS = Key.create((String)"run.extension.elements");
    private static final String EXT_ID_ATTR = "ID";
    private static final String EXTENSION_ROOT_ATTR = "EXTENSION";
    protected final ExtensionPointName<T> myExtensionPointName;

    public RunConfigurationExtensionsManager(ExtensionPointName<T> extensionPointName) {
        this.myExtensionPointName = extensionPointName;
    }

    public void readExternal(U configuration, Element parentNode) throws InvalidDataException {
        THashMap extensions = new THashMap();
        for (RunConfigurationExtensionBase extension : this.getApplicableExtensions(configuration)) {
            extensions.put(extension.getSerializationId(), extension);
        }
        List children = parentNode.getChildren(this.getExtensionRootAttr());
        boolean found = true;
        for (Element element : children) {
            RunConfigurationExtensionBase extension = (RunConfigurationExtensionBase)extensions.remove(element.getAttributeValue(this.getIdAttrName()));
            if (extension != null) {
                extension.readExternal(configuration, element);
                continue;
            }
            found = false;
        }
        if (!found) {
            ArrayList<Element> copy = new ArrayList<Element>(children.size());
            for (Element child : children) {
                copy.add(child.clone());
            }
            configuration.putCopyableUserData(RUN_EXTENSIONS, copy);
        }
    }

    protected String getIdAttrName() {
        return EXT_ID_ATTR;
    }

    protected String getExtensionRootAttr() {
        return EXTENSION_ROOT_ATTR;
    }

    public void writeExternal(U configuration, Element parentNode) {
        TreeMap map = ContainerUtil.newTreeMap();
        List elements = (List)configuration.getCopyableUserData(RUN_EXTENSIONS);
        if (elements != null) {
            for (Element element : elements) {
                map.put(element.getAttributeValue(this.getIdAttrName()), element.clone());
            }
        }
        for (RunConfigurationExtensionBase extension : this.getApplicableExtensions(configuration)) {
            Element element = new Element(this.getExtensionRootAttr());
            element.setAttribute(this.getIdAttrName(), extension.getSerializationId());
            try {
                extension.writeExternal(configuration, element);
            }
            catch (WriteExternalException ignored) {
                map.remove(extension.getSerializationId());
                continue;
            }
            map.put(extension.getSerializationId(), element);
        }
        for (Element values : map.values()) {
            parentNode.addContent(values);
        }
    }

    public <V extends U> void appendEditors(U configuration, SettingsEditorGroup<V> group) {
        for (RunConfigurationExtensionBase extension : this.getApplicableExtensions(configuration)) {
            SettingsEditor<U> editor = extension.createEditor(configuration);
            if (editor == null) continue;
            group.addEditor(extension.getEditorTitle(), editor);
        }
    }

    public void validateConfiguration(U configuration, boolean isExecution) throws Exception {
        for (RunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration, null)) {
            extension.validateConfiguration(configuration, isExecution);
        }
    }

    public void extendCreatedConfiguration(U configuration, Location location) {
        for (RunConfigurationExtensionBase extension : this.getApplicableExtensions(configuration)) {
            extension.extendCreatedConfiguration(configuration, location);
        }
    }

    public void extendTemplateConfiguration(U configuration) {
        for (RunConfigurationExtensionBase extension : this.getApplicableExtensions(configuration)) {
            extension.extendTemplateConfiguration(configuration);
        }
    }

    public void patchCommandLine(U configuration, RunnerSettings runnerSettings, GeneralCommandLine cmdLine, String runnerId) throws ExecutionException {
        for (RunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration, runnerSettings)) {
            extension.patchCommandLine(configuration, runnerSettings, cmdLine, runnerId);
        }
    }

    public void attachExtensionsToProcess(U configuration, ProcessHandler handler, RunnerSettings runnerSettings) {
        for (RunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration, runnerSettings)) {
            extension.attachToProcess(configuration, handler, runnerSettings);
        }
    }

    protected List<T> getApplicableExtensions(U configuration) {
        SmartList extensions = new SmartList();
        for (RunConfigurationExtensionBase extension : (RunConfigurationExtensionBase[])Extensions.getExtensions(this.myExtensionPointName)) {
            if (!extension.isApplicableFor(configuration)) continue;
            extensions.add(extension);
        }
        return extensions;
    }

    protected List<T> getEnabledExtensions(U configuration, RunnerSettings runnerSettings) {
        SmartList extensions = new SmartList();
        for (RunConfigurationExtensionBase extension : (RunConfigurationExtensionBase[])Extensions.getExtensions(this.myExtensionPointName)) {
            if (!extension.isApplicableFor(configuration) || !extension.isEnabledFor(configuration, runnerSettings)) continue;
            extensions.add(extension);
        }
        return extensions;
    }
}

