/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.IconUtil;
import javax.swing.Icon;

public abstract class ConfigurationFactory {
    public static final Icon ADD_ICON = IconUtil.getAddIcon();
    private final ConfigurationType myType;

    protected ConfigurationFactory(ConfigurationType type) {
        this.myType = type;
    }

    public RunConfiguration createConfiguration(String name, RunConfiguration template) {
        RunConfiguration newConfiguration = template.clone();
        newConfiguration.setName(name);
        return newConfiguration;
    }

    public boolean isApplicable(Project project) {
        return true;
    }

    public abstract RunConfiguration createTemplateConfiguration(Project var1);

    public RunConfiguration createTemplateConfiguration(Project project, RunManager runManager) {
        return this.createTemplateConfiguration(project);
    }

    public String getName() {
        return this.myType.getDisplayName();
    }

    public Icon getAddIcon() {
        return ADD_ICON;
    }

    public Icon getIcon(RunConfiguration configuration) {
        return this.getIcon();
    }

    public Icon getIcon() {
        return this.myType.getIcon();
    }

    public ConfigurationType getType() {
        return this.myType;
    }

    public void configureBeforeRunTaskDefaults(Key<? extends BeforeRunTask> providerID, BeforeRunTask task) {
    }

    public boolean isConfigurationSingletonByDefault() {
        return false;
    }

    public boolean canConfigurationBeSingleton() {
        return true;
    }
}

