/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.execution.ParametersListUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class ParametersList
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.ParametersList");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("-D(\\S+?)=(.+)");
    private List<String> myParameters = new ArrayList<String>();
    private Map<String, String> myMacroMap = null;
    private List<ParamsGroup> myGroups = new ArrayList<ParamsGroup>();

    public boolean hasParameter(@NonNls String param) {
        return this.myParameters.contains(param);
    }

    public boolean hasProperty(@NonNls String name) {
        return this.getPropertyValue(name) != null;
    }

    public String getPropertyValue(@NonNls String name) {
        String prefix = "-D" + name + "=";
        for (String parameter : this.myParameters) {
            if (!parameter.startsWith(prefix)) continue;
            return parameter.substring(prefix.length());
        }
        return null;
    }

    public Map<String, String> getProperties() {
        THashMap result = new THashMap();
        for (String parameter : this.myParameters) {
            Matcher matcher = PROPERTY_PATTERN.matcher(parameter);
            if (!matcher.matches()) continue;
            result.put(matcher.group(1), matcher.group(2));
        }
        return result;
    }

    public String getParametersString() {
        return ParametersList.join(this.getList());
    }

    public String[] getArray() {
        return ArrayUtil.toStringArray(this.getList());
    }

    public List<String> getList() {
        if (this.myGroups.isEmpty()) {
            return Collections.unmodifiableList(this.myParameters);
        }
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(this.myParameters);
        for (ParamsGroup group : this.myGroups) {
            params.addAll(group.getParameters());
        }
        return Collections.unmodifiableList(params);
    }

    public void clearAll() {
        this.myParameters.clear();
        this.myGroups.clear();
    }

    public void prepend(@NonNls String parameter) {
        this.addAt(0, parameter);
    }

    public void prependAll(String ... parameter) {
        this.addAll(parameter);
        Collections.rotate(this.myParameters, parameter.length);
    }

    public void addParametersString(String parameters) {
        if (parameters != null) {
            String[] split;
            for (String param : split = ParametersList.parse(parameters)) {
                this.add(param);
            }
        }
    }

    public void add(@NonNls String parameter) {
        this.myParameters.add(this.expandMacros(parameter));
    }

    public ParamsGroup addParamsGroup(String groupId) {
        return this.addParamsGroup(new ParamsGroup(groupId));
    }

    public ParamsGroup addParamsGroup(ParamsGroup group) {
        this.myGroups.add(group);
        return group;
    }

    public ParamsGroup addParamsGroupAt(int index, ParamsGroup group) {
        this.myGroups.add(index, group);
        return group;
    }

    public ParamsGroup addParamsGroupAt(int index, String groupId) {
        ParamsGroup group = new ParamsGroup(groupId);
        this.myGroups.add(index, group);
        return group;
    }

    public int getParamsGroupsCount() {
        return this.myGroups.size();
    }

    public List<String> getParameters() {
        return Collections.unmodifiableList(this.myParameters);
    }

    public List<ParamsGroup> getParamsGroups() {
        return Collections.unmodifiableList(this.myGroups);
    }

    public ParamsGroup getParamsGroupAt(int index) {
        return this.myGroups.get(index);
    }

    public ParamsGroup getParamsGroup(String name) {
        for (ParamsGroup group : this.myGroups) {
            if (!name.equals(group.getId())) continue;
            return group;
        }
        return null;
    }

    public ParamsGroup removeParamsGroup(int index) {
        return this.myGroups.remove(index);
    }

    public void addAt(int index, String parameter) {
        this.myParameters.add(index, this.expandMacros(parameter));
    }

    public void defineProperty(@NonNls String propertyName, @NonNls String propertyValue) {
        this.addProperty(propertyName, propertyValue);
    }

    public void addProperty(@NonNls String propertyName) {
        this.myParameters.add("-D" + propertyName);
    }

    public void addProperty(@NonNls String propertyName, @NonNls String propertyValue) {
        this.myParameters.add("-D" + propertyName + "=" + propertyValue);
    }

    public void replaceOrAppend(@NonNls String parameterPrefix, @NonNls String replacement) {
        this.replaceOrAdd(parameterPrefix, replacement, this.myParameters.size());
    }

    private void replaceOrAdd(@NonNls String parameterPrefix, @NonNls String replacement, int position) {
        ListIterator<String> iterator = this.myParameters.listIterator();
        while (iterator.hasNext()) {
            String param = iterator.next();
            if (!param.startsWith(parameterPrefix)) continue;
            if (replacement != null && replacement.isEmpty()) {
                iterator.remove();
            } else {
                iterator.set(replacement);
            }
            return;
        }
        if (replacement != null && !replacement.isEmpty()) {
            this.myParameters.add(position, replacement);
        }
    }

    public void replaceOrPrepend(@NonNls String parameter, @NonNls String replacement) {
        this.replaceOrAdd(parameter, replacement, 0);
    }

    public void set(int ind, @NonNls String value) {
        this.myParameters.set(ind, value);
    }

    public String get(int ind) {
        return this.myParameters.get(ind);
    }

    public void add(@NonNls String name, @NonNls String value) {
        this.add(name);
        this.add(value);
    }

    public void addAll(String ... parameters) {
        this.addAll(Arrays.asList(parameters));
    }

    public void addAll(List<String> parameters) {
        for (String parameter : parameters) {
            this.add(parameter);
        }
    }

    public ParametersList clone() {
        try {
            ParametersList clone = (ParametersList)super.clone();
            clone.myParameters = new ArrayList<String>(this.myParameters);
            clone.myGroups = new ArrayList<ParamsGroup>(this.myGroups.size() + 1);
            for (ParamsGroup group : this.myGroups) {
                clone.myGroups.add(group.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static String join(List<String> parameters) {
        return ParametersListUtil.join(parameters);
    }

    public static String join(String ... parameters) {
        return ParametersListUtil.join((String[])parameters);
    }

    public static String[] parse(String string) {
        return ParametersListUtil.parseToArray((String)string);
    }

    public String expandMacros(String text) {
        Map<String, String> macroMap = this.getMacroMap();
        Set<String> set = macroMap.keySet();
        for (String from : set) {
            String to = macroMap.get(from);
            text = StringUtil.replace((String)text, (String)from, (String)to, (boolean)true);
        }
        return text;
    }

    private Map<String, String> getMacroMap() {
        if (this.myMacroMap == null) {
            this.myMacroMap = new LinkedHashMap<String, String>();
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                PathMacros pathMacros = PathMacros.getInstance();
                if (pathMacros != null) {
                    for (String name : pathMacros.getUserMacroNames()) {
                        String value = pathMacros.getValue(name);
                        if (value == null) continue;
                        this.myMacroMap.put("${" + name + "}", value);
                    }
                }
                Map env = EnvironmentUtil.getEnvironmentMap();
                for (String name : env.keySet()) {
                    String key = "${" + name + "}";
                    if (this.myMacroMap.containsKey(key)) continue;
                    this.myMacroMap.put(key, (String)env.get(name));
                }
            }
        }
        return this.myMacroMap;
    }

    public String toString() {
        return this.myParameters.toString();
    }
}

