/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SmartList;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.List;

public class PathEnvironmentVariableUtil {
    private static final Logger LOG = Logger.getInstance(PathEnvironmentVariableUtil.class);
    private static final String PATH_ENV_VAR_NAME = "PATH";

    private PathEnvironmentVariableUtil() {
    }

    public static File findInPath(String fileBaseName) {
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, false);
    }

    public static File findInPath(String fileBaseName, FileFilter filter) {
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, false, filter);
    }

    public static File findInPath(String fileBaseName, boolean logDetails) {
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, logDetails, null);
    }

    private static File findInPath(String fileBaseName, boolean logDetails, FileFilter filter) {
        List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(fileBaseName, true, logDetails, filter);
        return exeFiles.size() > 0 ? exeFiles.get(0) : null;
    }

    private static File findInOriginalPath(String fileBaseName) {
        String originalPath = SystemInfo.isMac ? System.getenv(PATH_ENV_VAR_NAME) : EnvironmentUtil.getValue((String)PATH_ENV_VAR_NAME);
        List<File> exeFiles = PathEnvironmentVariableUtil.doFindExeFilesInPath(originalPath, fileBaseName, true, false, null);
        return exeFiles.size() > 0 ? exeFiles.get(0) : null;
    }

    public static List<File> findAllExeFilesInPath(String fileBaseName) {
        return PathEnvironmentVariableUtil.findAllExeFilesInPath(fileBaseName, null);
    }

    public static List<File> findAllExeFilesInPath(String fileBaseName, FileFilter filter) {
        return PathEnvironmentVariableUtil.findExeFilesInPath(fileBaseName, false, false, filter);
    }

    private static List<File> findExeFilesInPath(String fileBaseName, boolean stopAfterFirstMatch, boolean logDetails, FileFilter filter) {
        String systemPath = EnvironmentUtil.getValue((String)PATH_ENV_VAR_NAME);
        return PathEnvironmentVariableUtil.doFindExeFilesInPath(systemPath, fileBaseName, stopAfterFirstMatch, logDetails, filter);
    }

    private static List<File> doFindExeFilesInPath(String pathEnvVarValue, String fileBaseName, boolean stopAfterFirstMatch, boolean logDetails, FileFilter filter) {
        if (logDetails) {
            LOG.info("Finding files in PATH (base name=" + fileBaseName + ", PATH=" + StringUtil.notNullize((String)pathEnvVarValue) + ").");
        }
        if (pathEnvVarValue == null) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        List paths = StringUtil.split((String)pathEnvVarValue, (String)File.pathSeparator, (boolean)true, (boolean)true);
        for (String path : paths) {
            File exeFile;
            File dir = new File(path);
            if (logDetails) {
                File file = new File(dir, fileBaseName);
                LOG.info("path:" + path + ", path.isAbsolute:" + dir.isAbsolute() + ", path.isDirectory:" + dir.isDirectory() + ", file.isFile:" + file.isFile() + ", file.canExecute:" + file.canExecute());
            }
            if (!dir.isAbsolute() || !dir.isDirectory() || !(exeFile = new File(dir, fileBaseName)).isFile() || !exeFile.canExecute() || filter != null && !filter.accept(exeFile)) continue;
            result.add(exeFile);
            if (!stopAfterFirstMatch) continue;
            return result;
        }
        return result;
    }

    public static String findAbsolutePathOnMac(String exePath) {
        File resolvedExeFile;
        File originalResolvedExeFile;
        if (SystemInfo.isMac && !exePath.contains(File.separator) && (originalResolvedExeFile = PathEnvironmentVariableUtil.findInOriginalPath(exePath)) == null && (resolvedExeFile = PathEnvironmentVariableUtil.findInPath(exePath)) != null) {
            exePath = resolvedExeFile.getAbsolutePath();
        }
        return exePath;
    }
}

