/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.psi.PsiElement;

public class ConfigurationFromContextWrapper
extends ConfigurationFromContext {
    private final RuntimeConfigurationProducer myProducer;

    public ConfigurationFromContextWrapper(RuntimeConfigurationProducer producer) {
        this.myProducer = producer;
    }

    @Override
    public void onFirstRun(ConfigurationContext context, Runnable startRunnable) {
        this.myProducer.perform(context, startRunnable);
    }

    @Override
    public RunnerAndConfigurationSettings getConfigurationSettings() {
        return this.myProducer.getConfiguration();
    }

    @Override
    public void setConfigurationSettings(RunnerAndConfigurationSettings configurationSettings) {
        this.myProducer.setConfiguration(configurationSettings);
    }

    @Override
    public PsiElement getSourceElement() {
        return this.myProducer.getSourceElement();
    }

    @Override
    public boolean isPreferredTo(ConfigurationFromContext other) {
        return other instanceof ConfigurationFromContextWrapper && this.myProducer.compareTo(((ConfigurationFromContextWrapper)other).myProducer) < 0;
    }

    @Override
    public boolean shouldReplace(ConfigurationFromContext other) {
        return other instanceof ConfigurationFromContextWrapper && this.myProducer.compareTo(((ConfigurationFromContextWrapper)other).myProducer) > 0;
    }
}

