/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ColoredOutputTypeRegistry;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class AnsiEscapeDecoder {
    private static final char ESC_CHAR = '\u001b';
    private static final String CSI = "\u001b[";
    private static final Pattern INNER_PATTERN = Pattern.compile(Pattern.quote("m\u001b["));
    private final Map<String, Key> myCachedKeys = new HashMap<String, Key>();
    private Key myCurrentTextAttributes;

    public void escapeText(String text, Key outputType, ColoredTextAcceptor textAcceptor) {
        int escSeqBeginInd;
        List<Pair<String, Key>> chunks = null;
        int pos = 0;
        while ((escSeqBeginInd = text.indexOf(CSI, pos)) >= 0) {
            int escSeqEndInd;
            if (pos < escSeqBeginInd) {
                chunks = this.processTextChunk(chunks, text.substring(pos, escSeqBeginInd), outputType, textAcceptor);
            }
            if ((escSeqEndInd = AnsiEscapeDecoder.findEscSeqEndIndex(text, escSeqBeginInd)) < 0) break;
            if (text.charAt(escSeqEndInd - 1) == 'm') {
                String escSeq = text.substring(escSeqBeginInd, escSeqEndInd);
                String colorAttribute = INNER_PATTERN.matcher(escSeq).replaceAll(";");
                this.myCurrentTextAttributes = this.getOutputKey(colorAttribute);
            }
            pos = escSeqEndInd;
        }
        if (pos < text.length()) {
            chunks = this.processTextChunk(chunks, text.substring(pos), outputType, textAcceptor);
        }
        if (chunks != null && textAcceptor instanceof ColoredChunksAcceptor) {
            ((ColoredChunksAcceptor)textAcceptor).coloredChunksAvailable(chunks);
        }
    }

    private Key getOutputKey(String attribute) {
        Key key = this.myCachedKeys.get(attribute);
        if (key == null) {
            key = ColoredOutputTypeRegistry.getInstance().getOutputKey(attribute);
            this.myCachedKeys.put(attribute, key);
        }
        return key;
    }

    private static int findEscSeqEndIndex(String text, int escSeqBeginInd) {
        int beginInd = escSeqBeginInd;
        int letterInd;
        while ((letterInd = AnsiEscapeDecoder.findEscSeqLetterIndex(text, beginInd)) != -1) {
            if (text.charAt(letterInd) != 'm') {
                return beginInd == escSeqBeginInd ? letterInd + 1 : beginInd;
            }
            beginInd = letterInd + 1;
        }
        return beginInd == escSeqBeginInd ? -1 : beginInd;
    }

    private static int findEscSeqLetterIndex(String text, int escSeqBeginInd) {
        char letter;
        char ch;
        int parameterEndInd;
        if (!text.regionMatches(escSeqBeginInd, CSI, 0, CSI.length())) {
            return -1;
        }
        for (parameterEndInd = escSeqBeginInd + 2; parameterEndInd < text.length() && (Character.isDigit(ch = text.charAt(parameterEndInd)) || ch == ';'); ++parameterEndInd) {
        }
        if (parameterEndInd < text.length() && StringUtil.containsChar((String)"ABCDEFGHJKSTfmisu", (char)(letter = text.charAt(parameterEndInd)))) {
            return parameterEndInd;
        }
        return -1;
    }

    private List<Pair<String, Key>> processTextChunk(List<Pair<String, Key>> buffer, String text, Key outputType, ColoredTextAcceptor textAcceptor) {
        Key attributes = this.getCurrentOutputAttributes(outputType);
        if (textAcceptor instanceof ColoredChunksAcceptor) {
            if (buffer == null) {
                buffer = ContainerUtil.newArrayListWithCapacity((int)1);
            }
            buffer.add(Pair.create((Object)text, (Object)attributes));
        } else {
            textAcceptor.coloredTextAvailable(text, attributes);
        }
        return buffer;
    }

    protected Key getCurrentOutputAttributes(Key outputType) {
        if (outputType == ProcessOutputTypes.STDERR || outputType == ProcessOutputTypes.SYSTEM) {
            return outputType;
        }
        return this.myCurrentTextAttributes != null ? this.myCurrentTextAttributes : outputType;
    }

    public void coloredTextAvailable(List<Pair<String, Key>> textChunks, ColoredTextAcceptor textAcceptor) {
        for (Pair<String, Key> textChunk : textChunks) {
            textAcceptor.coloredTextAvailable((String)textChunk.getFirst(), (Key)textChunk.getSecond());
        }
    }

    public static interface ColoredTextAcceptor {
        public void coloredTextAvailable(String var1, Key var2);
    }

    public static interface ColoredChunksAcceptor
    extends ColoredTextAcceptor {
        public void coloredChunksAvailable(List<Pair<String, Key>> var1);
    }
}

