/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;

public class ProcessOutput {
    private final StringBuilder myStdoutBuilder = new StringBuilder();
    private final StringBuilder myStderrBuilder = new StringBuilder();
    private int myExitCode;
    private boolean myTimeout;
    private boolean myCancelled;

    public ProcessOutput() {
        this.myExitCode = -1;
    }

    public ProcessOutput(int exitCode) {
        this.myExitCode = exitCode;
    }

    public void appendStdout(String text) {
        this.myStdoutBuilder.append(text);
    }

    public void appendStderr(String text) {
        this.myStderrBuilder.append(text);
    }

    public String getStdout() {
        return this.myStdoutBuilder.toString();
    }

    public String getStderr() {
        return this.myStderrBuilder.toString();
    }

    public List<String> getStdoutLines() {
        return this.getStdoutLines(true);
    }

    public List<String> getStdoutLines(boolean excludeEmptyLines) {
        return ProcessOutput.splitLines(this.getStdout(), excludeEmptyLines);
    }

    public List<String> getStderrLines() {
        return this.getStderrLines(true);
    }

    public List<String> getStderrLines(boolean excludeEmptyLines) {
        return ProcessOutput.splitLines(this.getStderr(), excludeEmptyLines);
    }

    private static List<String> splitLines(String s, boolean excludeEmptyLines) {
        String converted = StringUtil.convertLineSeparators((String)s);
        return StringUtil.split((String)converted, (String)"\n", (boolean)true, (boolean)excludeEmptyLines);
    }

    public boolean checkSuccess(Logger logger) {
        if (this.getExitCode() != 0 || this.isTimeout()) {
            logger.info(this.getStderr() + (this.isTimeout() ? "\nTimed out" : "\nExit code " + this.getExitCode()));
            return false;
        }
        return true;
    }

    public void setExitCode(int exitCode) {
        this.myExitCode = exitCode;
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    public void setTimeout() {
        this.myTimeout = true;
    }

    public boolean isTimeout() {
        return this.myTimeout;
    }

    public void setCancelled() {
        this.myCancelled = true;
    }

    public boolean isCancelled() {
        return this.myCancelled;
    }
}

