/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.BaseProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.concurrency.Promise;

public abstract class AsyncGenericProgramRunner<Settings extends RunnerSettings>
extends BaseProgramRunner<Settings> {
    @Override
    protected final void execute(final ExecutionEnvironment environment, final ProgramRunner.Callback callback, final RunProfileState state) throws ExecutionException {
        this.prepare(environment, state).done(new Consumer<RunProfileStarter>(){

            public void consume(final RunProfileStarter result) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!environment.getProject().isDisposed()) {
                            AsyncGenericProgramRunner.startRunProfile(environment, state, callback, result);
                        }
                    }
                });
            }
        });
    }

    protected abstract Promise<RunProfileStarter> prepare(ExecutionEnvironment var1, RunProfileState var2) throws ExecutionException;

    private static void startRunProfile(ExecutionEnvironment environment, RunProfileState state, final ProgramRunner.Callback callback, final RunProfileStarter starter) {
        ExecutionManager.getInstance(environment.getProject()).startRunProfile(new RunProfileStarter(){

            @Override
            public RunContentDescriptor execute(RunProfileState state, ExecutionEnvironment environment) throws ExecutionException {
                return BaseProgramRunner.postProcess(environment, starter == null ? null : starter.execute(state, environment), callback);
            }
        }, state, environment);
    }
}

