/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NonNls;

public class ExecutionEnvironment
extends UserDataHolderBase
implements Disposable {
    private static final AtomicLong myIdHolder = new AtomicLong(1L);
    private final Project myProject;
    private RunProfile myRunProfile;
    private final Executor myExecutor;
    private ExecutionTarget myTarget;
    private RunnerSettings myRunnerSettings;
    private ConfigurationPerRunnerSettings myConfigurationSettings;
    private final RunnerAndConfigurationSettings myRunnerAndConfigurationSettings;
    private RunContentDescriptor myContentToReuse;
    private final ProgramRunner<?> myRunner;
    private long myExecutionId = 0L;
    private DataContext myDataContext;

    public ExecutionEnvironment() {
        this.myProject = null;
        this.myContentToReuse = null;
        this.myRunnerAndConfigurationSettings = null;
        this.myExecutor = null;
        this.myRunner = null;
    }

    public ExecutionEnvironment(Executor executor, ProgramRunner runner, RunnerAndConfigurationSettings configuration, Project project) {
        this(configuration.getConfiguration(), executor, DefaultExecutionTarget.INSTANCE, project, configuration.getRunnerSettings(runner), configuration.getConfigurationSettings(runner), null, null, runner);
    }

    public ExecutionEnvironment(Executor executor, ProgramRunner runner, ExecutionTarget target, RunnerAndConfigurationSettings configuration, Project project) {
        this(configuration.getConfiguration(), executor, target, project, configuration.getRunnerSettings(runner), configuration.getConfigurationSettings(runner), null, configuration, runner);
    }

    public ExecutionEnvironment(RunProfile runProfile, Executor executor, Project project, RunnerSettings runnerSettings) {
        this(runProfile, executor, DefaultExecutionTarget.INSTANCE, project, runnerSettings, null, null, null, RunnerRegistry.getInstance().getRunner(executor.getId(), runProfile));
    }

    ExecutionEnvironment(RunProfile runProfile, Executor executor, ExecutionTarget target, Project project, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSettings, RunContentDescriptor contentToReuse, RunnerAndConfigurationSettings settings, ProgramRunner<?> runner) {
        this.myExecutor = executor;
        this.myTarget = target;
        this.myRunProfile = runProfile;
        this.myRunnerSettings = runnerSettings;
        this.myConfigurationSettings = configurationSettings;
        this.myProject = project;
        this.setContentToReuse(contentToReuse);
        this.myRunnerAndConfigurationSettings = settings;
        this.myRunner = runner;
    }

    public void dispose() {
        this.myContentToReuse = null;
    }

    public Project getProject() {
        return this.myProject;
    }

    public ExecutionTarget getExecutionTarget() {
        return this.myTarget;
    }

    public RunProfile getRunProfile() {
        return this.myRunProfile;
    }

    public RunnerAndConfigurationSettings getRunnerAndConfigurationSettings() {
        return this.myRunnerAndConfigurationSettings;
    }

    public RunContentDescriptor getContentToReuse() {
        return this.myContentToReuse;
    }

    public void setContentToReuse(RunContentDescriptor contentToReuse) {
        this.myContentToReuse = contentToReuse;
        if (contentToReuse != null) {
            Disposer.register((Disposable)contentToReuse, (Disposable)this);
        }
    }

    @Deprecated
    public String getRunnerId() {
        return this.myRunner.getRunnerId();
    }

    public ProgramRunner<?> getRunner() {
        return this.myRunner;
    }

    public RunnerSettings getRunnerSettings() {
        return this.myRunnerSettings;
    }

    public ConfigurationPerRunnerSettings getConfigurationSettings() {
        return this.myConfigurationSettings;
    }

    public RunProfileState getState() throws ExecutionException {
        return this.myRunProfile.getState(this.myExecutor, this);
    }

    public long assignNewExecutionId() {
        this.myExecutionId = myIdHolder.incrementAndGet();
        return this.myExecutionId;
    }

    public void setExecutionId(long executionId) {
        this.myExecutionId = executionId;
    }

    public long getExecutionId() {
        return this.myExecutionId;
    }

    public Executor getExecutor() {
        return this.myExecutor;
    }

    public String toString() {
        if (this.myRunnerAndConfigurationSettings != null) {
            return this.myRunnerAndConfigurationSettings.getName();
        }
        if (this.myRunProfile != null) {
            return this.myRunProfile.getName();
        }
        if (this.myContentToReuse != null) {
            return this.myContentToReuse.getDisplayName();
        }
        return super.toString();
    }

    void setDataContext(DataContext dataContext) {
        this.myDataContext = CachingDataContext.cacheIfNeed(dataContext);
    }

    public DataContext getDataContext() {
        return this.myDataContext;
    }

    private static class CachingDataContext
    implements DataContext {
        private static final DataKey[] keys = new DataKey[]{LangDataKeys.PROJECT, LangDataKeys.PROJECT_FILE_DIRECTORY, LangDataKeys.EDITOR, LangDataKeys.VIRTUAL_FILE, LangDataKeys.MODULE, LangDataKeys.PSI_FILE};
        private final Map<String, Object> values = new HashMap<String, Object>();

        static CachingDataContext cacheIfNeed(DataContext context) {
            if (context instanceof CachingDataContext) {
                return (CachingDataContext)context;
            }
            return new CachingDataContext(context);
        }

        private CachingDataContext(DataContext context) {
            for (DataKey key : keys) {
                this.values.put(key.getName(), key.getData(context));
            }
        }

        @Override
        public Object getData(@NonNls String dataId) {
            return this.values.get(dataId);
        }
    }
}

