/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.autodetecting.FacetDetectorRegistry;
import com.intellij.facet.ui.DefaultFacetSettingsEditor;
import com.intellij.facet.ui.FacetEditor;
import com.intellij.facet.ui.MultipleFacetSettingsEditor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;

public abstract class FacetType<F extends Facet, C extends FacetConfiguration> {
    public static final ExtensionPointName<FacetType> EP_NAME = ExtensionPointName.create((String)"com.intellij.facetType");
    private final FacetTypeId<F> myId;
    private final String myStringId;
    private final String myPresentableName;
    private final FacetTypeId myUnderlyingFacetType;

    public static <T extends FacetType> T findInstance(Class<T> aClass) {
        return (T)((FacetType)EP_NAME.findExtension(aClass));
    }

    public FacetType(FacetTypeId<F> id, @NonNls String stringId, String presentableName, FacetTypeId underlyingFacetType) {
        this.myId = id;
        this.myStringId = stringId;
        this.myPresentableName = presentableName;
        this.myUnderlyingFacetType = underlyingFacetType;
    }

    public FacetType(FacetTypeId<F> id, @NonNls String stringId, String presentableName) {
        this(id, stringId, presentableName, null);
    }

    public final FacetTypeId<F> getId() {
        return this.myId;
    }

    public final String getStringId() {
        return this.myStringId;
    }

    public String getPresentableName() {
        return this.myPresentableName;
    }

    @NonNls
    public String getDefaultFacetName() {
        return this.myPresentableName;
    }

    public final FacetTypeId<?> getUnderlyingFacetType() {
        return this.myUnderlyingFacetType;
    }

    public void registerDetectors(FacetDetectorRegistry<C> registry) {
    }

    public abstract C createDefaultConfiguration();

    public abstract F createFacet(Module var1, String var2, C var3, Facet var4);

    public boolean isOnlyOneFacetAllowed() {
        return true;
    }

    public abstract boolean isSuitableModuleType(ModuleType var1);

    public Icon getIcon() {
        return null;
    }

    @NonNls
    public String getHelpTopic() {
        return null;
    }

    public DefaultFacetSettingsEditor createDefaultConfigurationEditor(Project project, C configuration) {
        return null;
    }

    public MultipleFacetSettingsEditor createMultipleConfigurationsEditor(Project project, FacetEditor[] editors) {
        return null;
    }
}

