/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProviderBase;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;

public abstract class FacetBasedFrameworkSupportProvider<F extends Facet>
extends FrameworkSupportProviderBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.ui.FacetBasedFrameworkSupportProvider");
    @NonNls
    private static final String FACET_SUPPORT_PREFIX = "facet:";
    private final FacetType<F, ?> myFacetType;

    protected FacetBasedFrameworkSupportProvider(FacetType<F, ?> facetType) {
        super(FacetBasedFrameworkSupportProvider.getProviderId(facetType), facetType.getPresentableName());
        this.myFacetType = facetType;
    }

    public static String getProviderId(FacetType facetType) {
        return FACET_SUPPORT_PREFIX + facetType.getStringId();
    }

    public static String getProviderId(FacetTypeId<?> typeId) {
        return FacetBasedFrameworkSupportProvider.getProviderId(FacetTypeRegistry.getInstance().findFacetType(typeId));
    }

    @Override
    public String getUnderlyingFrameworkId() {
        FacetTypeId<?> typeId = this.myFacetType.getUnderlyingFacetType();
        if (typeId == null) {
            return null;
        }
        return FacetBasedFrameworkSupportProvider.getProviderId(FacetTypeRegistry.getInstance().findFacetType(typeId));
    }

    @Override
    public boolean isEnabledForModuleType(ModuleType moduleType) {
        return this.myFacetType.isSuitableModuleType(moduleType);
    }

    @Override
    public boolean isSupportAlreadyAdded(Module module, FacetsProvider facetsProvider) {
        return !facetsProvider.getFacetsByType(module, this.myFacetType.getId()).isEmpty();
    }

    @Override
    public Icon getIcon() {
        return this.myFacetType.getIcon();
    }

    @Override
    protected void addSupport(Module module, ModifiableRootModel rootModel, FrameworkVersion version, Library library) {
        FacetManager facetManager = FacetManager.getInstance(module);
        ModifiableFacetModel model = facetManager.createModifiableModel();
        Facet underlyingFacet = null;
        FacetTypeId<?> underlyingFacetType = this.myFacetType.getUnderlyingFacetType();
        if (underlyingFacetType != null) {
            underlyingFacet = (Facet)((Object)model.getFacetByType(underlyingFacetType));
            LOG.assertTrue(underlyingFacet != null, underlyingFacetType);
        }
        F facet = facetManager.createFacet(this.myFacetType, this.myFacetType.getDefaultFacetName(), underlyingFacet);
        this.setupConfiguration(facet, rootModel, version);
        if (library != null) {
            this.onLibraryAdded(facet, library);
        }
        model.addFacet((Facet)((Object)facet));
        model.commit();
        this.onFacetCreated(facet, rootModel, version);
    }

    protected void onFacetCreated(F facet, ModifiableRootModel rootModel, FrameworkVersion version) {
    }

    protected void onLibraryAdded(F facet, Library library) {
    }

    protected abstract void setupConfiguration(F var1, ModifiableRootModel var2, FrameworkVersion var3);

    public void processAddedLibraries(Module module, List<Library> addedLibraries) {
    }
}

