/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import gnu.trove.TObjectIntHashMap;

public class DependentSpacingRule {
    public static final DependentSpacingRule DEFAULT = new DependentSpacingRule(Trigger.HAS_LINE_FEEDS).registerData(Anchor.MIN_LINE_FEEDS, 1);
    private final TObjectIntHashMap<Anchor> myData = new TObjectIntHashMap();
    private final Trigger myTrigger;

    public DependentSpacingRule(Trigger trigger) {
        this.myTrigger = trigger;
    }

    public Trigger getTrigger() {
        return this.myTrigger;
    }

    public DependentSpacingRule registerData(Anchor anchor, int data) {
        this.myData.put((Object)anchor, data);
        return this;
    }

    public boolean hasData(Anchor anchor) {
        return this.myData.containsKey((Object)anchor);
    }

    public int getData(Anchor anchor) throws IllegalArgumentException {
        if (!this.myData.containsKey((Object)anchor)) {
            throw new IllegalArgumentException(String.format("No data is registered for the dependent spacing rule %s. Registered: %s", new Object[]{anchor, this.myData}));
        }
        return this.myData.get((Object)anchor);
    }

    public static enum Trigger {
        HAS_LINE_FEEDS,
        DOES_NOT_HAVE_LINE_FEEDS;

    }

    public static enum Anchor {
        MIN_LINE_FEEDS,
        MAX_LINE_FEEDS;

    }
}

