/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import java.util.List;

public abstract class FrameworkDetector {
    public static final ExtensionPointName<FrameworkDetector> EP_NAME = ExtensionPointName.create((String)"com.intellij.framework.detector");
    private final String myDetectorId;
    private final int myDetectorVersion;

    protected FrameworkDetector(String detectorId) {
        this(detectorId, 0);
    }

    protected FrameworkDetector(String detectorId, int detectorVersion) {
        this.myDetectorId = detectorId;
        this.myDetectorVersion = detectorVersion;
    }

    public abstract FileType getFileType();

    public abstract ElementPattern<FileContent> createSuitableFilePattern();

    public abstract List<? extends DetectedFrameworkDescription> detect(Collection<VirtualFile> var1, FrameworkDetectionContext var2);

    public abstract FrameworkType getFrameworkType();

    public FrameworkType getUnderlyingFrameworkType() {
        return null;
    }

    public final String getDetectorId() {
        return this.myDetectorId;
    }

    public final int getDetectorVersion() {
        return this.myDetectorVersion;
    }
}

