/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class BrowserUtil {
    private static final Pattern ourExternalPrefix = Pattern.compile("^[\\w\\+\\.\\-]{2,}:");
    private static final Pattern ourAnchorSuffix = Pattern.compile("#(.*)$");
    private static final Condition<String> BROWSABLE_URL = new Condition<String>(){

        public boolean value(String s) {
            return BrowserUtil.canBeBrowsed(s);
        }
    };

    private BrowserUtil() {
    }

    public static boolean isAbsoluteURL(String url) {
        return ourExternalPrefix.matcher(url.toLowerCase(Locale.ENGLISH)).find();
    }

    public static boolean canBeBrowsed(String url) {
        return url != null && !url.startsWith("jar:");
    }

    public static List<String> retainBrowsableUrls(List<String> urls) {
        return urls == null ? null : ContainerUtil.filter(urls, BROWSABLE_URL);
    }

    public static String getDocURL(String url) {
        Matcher anchorMatcher = ourAnchorSuffix.matcher(url);
        return anchorMatcher.find() ? anchorMatcher.reset().replaceAll("") : url;
    }

    public static URL getURL(String url) throws MalformedURLException {
        return BrowserUtil.isAbsoluteURL(url) ? VfsUtilCore.convertToURL(url) : new URL("file", "", url);
    }

    public static void browse(VirtualFile file) {
        BrowserUtil.browse(VfsUtil.toUri(file));
    }

    public static void browse(File file) {
        BrowserUtil.getBrowserLauncher().browse(file);
    }

    public static void browse(URL url) {
        BrowserUtil.browse(url.toExternalForm());
    }

    @Deprecated
    public static void launchBrowser(@NonNls String url) {
        BrowserUtil.browse(url);
    }

    public static void browse(@NonNls String url) {
        BrowserUtil.getBrowserLauncher().browse(url, null);
    }

    private static BrowserLauncher getBrowserLauncher() {
        BrowserLauncher launcher = ApplicationManager.getApplication() == null ? null : BrowserLauncher.getInstance();
        return launcher == null ? new BrowserLauncherAppless() : launcher;
    }

    public static void open(@NonNls String url) {
        BrowserUtil.getBrowserLauncher().open(url);
    }

    public static void browse(URI uri) {
        BrowserUtil.getBrowserLauncher().browse(uri);
    }

    public static void browse(String url, Project project) {
        BrowserUtil.getBrowserLauncher().browse(url, null, project);
    }

    @Deprecated
    public static List<String> getOpenBrowserCommand(@NonNls String browserPathOrName) {
        return BrowserUtil.getOpenBrowserCommand(browserPathOrName, false);
    }

    public static List<String> getOpenBrowserCommand(@NonNls String browserPathOrName, boolean newWindowIfPossible) {
        if (new File(browserPathOrName).isFile()) {
            return Collections.singletonList(browserPathOrName);
        }
        if (SystemInfo.isMac) {
            ArrayList command = ContainerUtilRt.newArrayList((Object[])new String[]{ExecUtil.getOpenCommandPath(), "-a", browserPathOrName});
            if (newWindowIfPossible) {
                command.add("-n");
            }
            return command;
        }
        if (SystemInfo.isWindows) {
            return Arrays.asList(ExecUtil.getWindowsShellName(), "/c", "start", GeneralCommandLine.inescapableQuote(""), browserPathOrName);
        }
        return Collections.singletonList(browserPathOrName);
    }

    public static boolean isOpenCommandSupportArgs() {
        return SystemInfo.isMacOSSnowLeopard;
    }

    public static String getDefaultAlternativeBrowserPath() {
        if (SystemInfo.isWindows) {
            return "C:\\Program Files\\Internet Explorer\\IExplore.exe";
        }
        if (SystemInfo.isMac) {
            return "open";
        }
        if (SystemInfo.isUnix) {
            return "/usr/bin/firefox";
        }
        return "";
    }
}

