/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Key;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public abstract class DataManager {
    @NonNls
    public static final String CLIENT_PROPERTY_DATA_PROVIDER = "DataProvider";

    public static DataManager getInstance() {
        Application application = ApplicationManager.getApplication();
        return application != null ? application.getComponent(DataManager.class) : null;
    }

    public abstract DataContext getDataContext();

    public abstract AsyncResult<DataContext> getDataContextFromFocus();

    public abstract DataContext getDataContext(Component var1);

    public abstract DataContext getDataContext(Component var1, int var2, int var3);

    public abstract <T> void saveInDataContext(DataContext var1, Key<T> var2, T var3);

    public abstract <T> T loadFromDataContext(DataContext var1, Key<T> var2);

    public static void registerDataProvider(JComponent component, DataProvider provider) {
        component.putClientProperty(CLIENT_PROPERTY_DATA_PROVIDER, provider);
    }

    public static DataProvider getDataProvider(JComponent component) {
        return (DataProvider)component.getClientProperty(CLIENT_PROPERTY_DATA_PROVIDER);
    }

    public static void removeDataProvider(JComponent component) {
        component.putClientProperty(CLIENT_PROPERTY_DATA_PROVIDER, null);
    }
}

