/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Url;
import java.util.Collection;

public abstract class OpenInBrowserRequest {
    private Collection<Url> result;
    protected PsiFile file;

    public OpenInBrowserRequest(PsiFile file) {
        this.file = file;
    }

    public OpenInBrowserRequest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenInBrowserRequest create(final PsiElement element) {
        PsiFile psiFile;
        AccessToken token = ReadAction.start();
        try {
            PsiFile psiFile2 = psiFile = element.isValid() ? element.getContainingFile() : null;
            if (psiFile == null || psiFile.getVirtualFile() == null) {
                OpenInBrowserRequest openInBrowserRequest = null;
                return openInBrowserRequest;
            }
        }
        finally {
            token.finish();
        }
        return new OpenInBrowserRequest(psiFile){

            @Override
            public PsiElement getElement() {
                return element;
            }
        };
    }

    public PsiFile getFile() {
        return this.file;
    }

    public VirtualFile getVirtualFile() {
        return this.file.getVirtualFile();
    }

    public Project getProject() {
        return this.file.getProject();
    }

    public abstract PsiElement getElement();

    public void setResult(Collection<Url> result) {
        this.result = result;
    }

    public Collection<Url> getResult() {
        return this.result;
    }
}

