/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;

public abstract class WebBrowserUrlProvider {
    public static final ExtensionPointName<WebBrowserUrlProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.webBrowserUrlProvider");

    public boolean canHandleElement(OpenInBrowserRequest request) {
        try {
            Collection<Url> urls = this.getUrls(request);
            if (!urls.isEmpty()) {
                request.setResult(urls);
                return true;
            }
        }
        catch (BrowserException browserException) {
            // empty catch block
        }
        return false;
    }

    protected Url getUrl(OpenInBrowserRequest request, VirtualFile file) throws BrowserException {
        return null;
    }

    public Collection<Url> getUrls(OpenInBrowserRequest request) throws BrowserException {
        return ContainerUtil.createMaybeSingletonList((Object)this.getUrl(request, request.getVirtualFile()));
    }

    @Deprecated
    public String getOpenInBrowserActionDescription(PsiFile file) {
        return null;
    }

    public static class BrowserException
    extends Exception {
        public BrowserException(String message) {
            super(message);
        }
    }
}

