/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.chrome;

import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.chrome.ChromeSettingsConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ChromeSettings
extends BrowserSpecificSettings {
    public static final String USER_DATA_DIR_ARG = "--user-data-dir=";
    private String myCommandLineOptions;
    private String myUserDataDirectoryPath;
    private boolean myUseCustomProfile;
    private Map<String, String> myEnvironmentVariables = new THashMap();

    @Tag(value="user-data-dir")
    public String getUserDataDirectoryPath() {
        return this.myUserDataDirectoryPath;
    }

    @Tag(value="use-custom-profile")
    public boolean isUseCustomProfile() {
        return this.myUseCustomProfile;
    }

    @Tag(value="command-line-options")
    public String getCommandLineOptions() {
        return this.myCommandLineOptions;
    }

    public void setCommandLineOptions(String value) {
        this.myCommandLineOptions = StringUtil.nullize((String)value);
    }

    public void setUserDataDirectoryPath(String value) {
        this.myUserDataDirectoryPath = PathUtil.toSystemIndependentName(StringUtil.nullize((String)value));
    }

    public void setUseCustomProfile(boolean useCustomProfile) {
        this.myUseCustomProfile = useCustomProfile;
    }

    @Override
    public List<String> getAdditionalParameters() {
        if (this.myCommandLineOptions == null) {
            if (this.myUseCustomProfile && this.myUserDataDirectoryPath != null) {
                return Collections.singletonList(USER_DATA_DIR_ARG + FileUtilRt.toSystemDependentName((String)this.myUserDataDirectoryPath));
            }
            return Collections.emptyList();
        }
        List cliOptions = ParametersListUtil.parse((String)this.myCommandLineOptions);
        if (this.myUseCustomProfile && this.myUserDataDirectoryPath != null) {
            cliOptions.add(USER_DATA_DIR_ARG + FileUtilRt.toSystemDependentName((String)this.myUserDataDirectoryPath));
        }
        return cliOptions;
    }

    @Override
    @Tag(value="environment-variables")
    @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
    public Map<String, String> getEnvironmentVariables() {
        return this.myEnvironmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.myEnvironmentVariables = environmentVariables;
    }

    @Override
    public ChromeSettingsConfigurable createConfigurable() {
        return new ChromeSettingsConfigurable(this);
    }

    @Override
    public ChromeSettings clone() {
        ChromeSettings clone = (ChromeSettings)super.clone();
        clone.myEnvironmentVariables = new THashMap(this.myEnvironmentVariables);
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChromeSettings settings = (ChromeSettings)o;
        return this.myUseCustomProfile == settings.myUseCustomProfile && Comparing.equal((String)this.myCommandLineOptions, (String)settings.myCommandLineOptions) && (!this.myUseCustomProfile || Comparing.equal((String)this.myUserDataDirectoryPath, (String)settings.myUserDataDirectoryPath)) && ((Object)this.myEnvironmentVariables).equals(settings.myEnvironmentVariables);
    }
}

