/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class TextEditorBasedStructureViewModel
implements StructureViewModel,
ProvidingTreeModel {
    private final Editor myEditor;
    private final PsiFile myPsiFile;
    private final Disposable myDisposable = Disposer.newDisposable();
    private final List<FileEditorPositionListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private List<ModelListener> myModelListeners = new ArrayList<ModelListener>(2);
    private CaretAdapter myEditorCaretListener;

    protected TextEditorBasedStructureViewModel(PsiFile psiFile) {
        this(PsiEditorUtil.Service.getInstance().findEditorByPsiElement(psiFile), psiFile);
    }

    protected TextEditorBasedStructureViewModel(Editor editor) {
        this(editor, null);
    }

    protected TextEditorBasedStructureViewModel(Editor editor, PsiFile file) {
        this.myEditor = editor;
        this.myPsiFile = file;
        this.myEditorCaretListener = new CaretAdapter(){

            @Override
            public void caretPositionChanged(CaretEvent e) {
                if (e.getEditor().equals(TextEditorBasedStructureViewModel.this.myEditor)) {
                    for (FileEditorPositionListener listener : TextEditorBasedStructureViewModel.this.myListeners) {
                        listener.onCurrentElementChanged();
                    }
                }
            }
        };
    }

    @Override
    public final void addEditorPositionListener(FileEditorPositionListener listener) {
        if (this.myEditor != null && this.myListeners.isEmpty()) {
            EditorFactory.getInstance().getEventMulticaster().addCaretListener(this.myEditorCaretListener, this.myDisposable);
        }
        this.myListeners.add(listener);
    }

    @Override
    public final void removeEditorPositionListener(FileEditorPositionListener listener) {
        this.myListeners.remove(listener);
        if (this.myEditor != null && this.myListeners.isEmpty()) {
            EditorFactory.getInstance().getEventMulticaster().removeCaretListener(this.myEditorCaretListener);
        }
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
        this.myModelListeners.clear();
    }

    public void fireModelUpdate() {
        for (ModelListener listener : this.myModelListeners) {
            listener.onModelChanged();
        }
    }

    @Override
    public boolean shouldEnterElement(Object element) {
        return false;
    }

    @Override
    public Object getCurrentEditorElement() {
        if (this.myEditor == null) {
            return null;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        PsiFile file = this.getPsiFile();
        return this.findAcceptableElement(file.getViewProvider().findElementAt(offset, file.getLanguage()));
    }

    protected Object findAcceptableElement(PsiElement element) {
        while (element != null && !(element instanceof PsiFile)) {
            if (this.isSuitable(element)) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    protected PsiFile getPsiFile() {
        return this.myPsiFile;
    }

    protected boolean isSuitable(PsiElement element) {
        Class[] suitableClasses;
        if (element == null) {
            return false;
        }
        for (Class suitableClass : suitableClasses = this.getSuitableClasses()) {
            if (!ReflectionUtil.isAssignable((Class)suitableClass, element.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addModelListener(ModelListener modelListener) {
        this.myModelListeners.add(modelListener);
    }

    @Override
    public void removeModelListener(ModelListener modelListener) {
        this.myModelListeners.remove(modelListener);
    }

    protected Class[] getSuitableClasses() {
        return ArrayUtil.EMPTY_CLASS_ARRAY;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    @Override
    public Grouper[] getGroupers() {
        return Grouper.EMPTY_ARRAY;
    }

    @Override
    public Sorter[] getSorters() {
        return Sorter.EMPTY_ARRAY;
    }

    @Override
    public Filter[] getFilters() {
        return Filter.EMPTY_ARRAY;
    }

    @Override
    public Collection<NodeProvider> getNodeProviders() {
        return Collections.emptyList();
    }

    @Override
    public boolean isEnabled(NodeProvider provider) {
        return false;
    }
}

