/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.openapi.util.Comparing;

public class OptionDescription
implements Comparable {
    private String myOption;
    private final String myHit;
    private String myPath;
    private String myConfigurableId;

    public OptionDescription(String option, String hit, String path) {
        this.myOption = option;
        this.myHit = hit;
        this.myPath = path;
    }

    public OptionDescription(String hit) {
        this.myHit = hit;
    }

    public OptionDescription(String option, String configurableId, String hit, String path) {
        this.myOption = option;
        this.myHit = hit;
        this.myPath = path;
        this.myConfigurableId = configurableId;
    }

    public String getOption() {
        return this.myOption;
    }

    public String getHit() {
        return this.myHit;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getConfigurableId() {
        return this.myConfigurableId;
    }

    public String toString() {
        return this.myHit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionDescription that = (OptionDescription)o;
        if (this.myConfigurableId != null ? !this.myConfigurableId.equals(that.myConfigurableId) : that.myConfigurableId != null) {
            return false;
        }
        if (this.myHit != null ? !this.myHit.equals(that.myHit) : that.myHit != null) {
            return false;
        }
        if (this.myOption != null ? !this.myOption.equals(that.myOption) : that.myOption != null) {
            return false;
        }
        return !(this.myPath != null ? !this.myPath.equals(that.myPath) : that.myPath != null);
    }

    public int hashCode() {
        int result = this.myOption != null ? this.myOption.hashCode() : 0;
        result = 31 * result + (this.myHit != null ? this.myHit.hashCode() : 0);
        result = 31 * result + (this.myPath != null ? this.myPath.hashCode() : 0);
        result = 31 * result + (this.myConfigurableId != null ? this.myConfigurableId.hashCode() : 0);
        return result;
    }

    public int compareTo(Object o) {
        OptionDescription description = (OptionDescription)o;
        if (Comparing.strEqual((String)this.myHit, (String)description.getHit())) {
            return this.myOption != null ? this.myOption.compareTo(description.getOption()) : 0;
        }
        if (this.myHit != null && description.getHit() != null) {
            return this.myHit.compareTo(description.getHit());
        }
        return 0;
    }
}

