/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeRunnable;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Condition;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;

public class AbstractTreeBuilder
implements Disposable {
    private AbstractTreeUi myUi;
    @NonNls
    private static final String TREE_BUILDER = "TreeBuilder";
    public static final boolean DEFAULT_UPDATE_INACTIVE = true;
    private final TransferToEDTQueue<Runnable> myLaterInvocator = new TransferToEDTQueue("Tree later invocator", (Processor)new Processor<Runnable>(){

        public boolean process(Runnable runnable) {
            runnable.run();
            return true;
        }
    }, (Condition)new Condition<Object>(){

        public boolean value(Object o) {
            return AbstractTreeBuilder.this.isDisposed();
        }
    }, 200);

    public AbstractTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, Comparator<NodeDescriptor> comparator) {
        this(tree, treeModel, treeStructure, comparator, true);
    }

    public AbstractTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, Comparator<NodeDescriptor> comparator, boolean updateIfInactive) {
        this.init(tree, treeModel, treeStructure, comparator, updateIfInactive);
    }

    protected AbstractTreeBuilder() {
    }

    protected void init(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, Comparator<NodeDescriptor> comparator, boolean updateIfInactive) {
        tree.putClientProperty(TREE_BUILDER, new WeakReference<AbstractTreeBuilder>(this));
        this.myUi = this.createUi();
        this.getUi().init(this, tree, treeModel, treeStructure, comparator, updateIfInactive);
        this.setPassthroughMode(AbstractTreeBuilder.isUnitTestingMode());
    }

    protected AbstractTreeUi createUi() {
        return new AbstractTreeUi();
    }

    public final void select(Object element) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().userSelect(new Object[]{element}, null, false, true);
    }

    public final void select(Object element, Runnable onDone) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().userSelect(new Object[]{element}, new UserRunnable(onDone), false, true);
    }

    public final void select(Object element, Runnable onDone, boolean addToSelection) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().userSelect(new Object[]{element}, new UserRunnable(onDone), addToSelection, true);
    }

    public final void select(Object[] elements, Runnable onDone) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().userSelect(elements, new UserRunnable(onDone), false, true);
    }

    public final void select(Object[] elements, Runnable onDone, boolean addToSelection) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().userSelect(elements, new UserRunnable(onDone), addToSelection, true);
    }

    public final void expand(Object element, Runnable onDone) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().expand(element, (Runnable)new UserRunnable(onDone));
    }

    public final void expand(Object[] element, Runnable onDone) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().expand(element, (Runnable)new UserRunnable(onDone));
    }

    public final void collapseChildren(Object element, Runnable onDone) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().collapseChildren(element, new UserRunnable(onDone));
    }

    protected AbstractTreeNode createSearchingTreeNodeWrapper() {
        return new AbstractTreeNodeWrapper();
    }

    public final AbstractTreeBuilder setClearOnHideDelay(long clearOnHideDelay) {
        if (this.isDisposed()) {
            return this;
        }
        this.getUi().setClearOnHideDelay(clearOnHideDelay);
        return this;
    }

    protected AbstractTreeUpdater createUpdater() {
        if (this.isDisposed()) {
            return null;
        }
        AbstractTreeUpdater updater = new AbstractTreeUpdater(this);
        updater.setModalityStateComponent(MergingUpdateQueue.ANY_COMPONENT);
        return updater;
    }

    protected final AbstractTreeUpdater getUpdater() {
        if (this.isDisposed()) {
            return null;
        }
        return this.getUi().getUpdater();
    }

    public final boolean addSubtreeToUpdateByElement(Object element) {
        if (this.isDisposed()) {
            return false;
        }
        AbstractTreeUpdater updater = this.getUpdater();
        return updater != null && updater.addSubtreeToUpdateByElement(element);
    }

    public final void addSubtreeToUpdate(DefaultMutableTreeNode node) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().addSubtreeToUpdate(node);
    }

    public final void addSubtreeToUpdate(DefaultMutableTreeNode node, Runnable afterUpdate) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().addSubtreeToUpdate(node, afterUpdate);
    }

    public final DefaultMutableTreeNode getRootNode() {
        if (this.isDisposed()) {
            return null;
        }
        return this.getUi().getRootNode();
    }

    public final void setNodeDescriptorComparator(Comparator<NodeDescriptor> nodeDescriptorComparator) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().setNodeDescriptorComparator(nodeDescriptorComparator);
    }

    protected Object getTreeStructureElement(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor.getElement();
    }

    protected void updateNode(DefaultMutableTreeNode node) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().doUpdateNode(node);
    }

    protected boolean validateNode(Object child) {
        return !this.isDisposed() && this.getUi().getTreeStructure().isValid(child);
    }

    protected boolean isDisposeOnCollapsing(NodeDescriptor nodeDescriptor) {
        return true;
    }

    public final JTree getTree() {
        if (this.isDisposed()) {
            return null;
        }
        return this.getUi().getTree();
    }

    public final AbstractTreeStructure getTreeStructure() {
        if (this.isDisposed()) {
            return null;
        }
        return this.getUi().getTreeStructure();
    }

    public final void setTreeStructure(AbstractTreeStructure structure) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().setTreeStructure(structure);
    }

    public Object getRootElement() {
        AbstractTreeStructure structure = this.getTreeStructure();
        return structure == null ? null : structure.getRootElement();
    }

    public void updateFromRoot() {
        this.queueUpdate();
    }

    public void initRootNode() {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().initRootNode();
    }

    protected ActionCallback updateFromRootCB() {
        return this.queueUpdate();
    }

    public final ActionCallback queueUpdate() {
        return this.queueUpdate(true);
    }

    public final ActionCallback queueUpdate(boolean withStructure) {
        return this.queueUpdateFrom(this.getRootElement(), true, withStructure);
    }

    public final ActionCallback queueUpdateFrom(Object element, boolean forceResort) {
        return this.queueUpdateFrom(element, forceResort, true);
    }

    public ActionCallback queueUpdateFrom(final Object element, final boolean forceResort, final boolean updateStructure) {
        if (this.getUi() == null) {
            return new ActionCallback.Rejected();
        }
        final ActionCallback result = new ActionCallback();
        this.getUi().invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeBuilder.queueUpdateFrom"){

            @Override
            public void perform() {
                if (updateStructure && forceResort) {
                    AbstractTreeBuilder.this.getUi().incComparatorStamp();
                }
                AbstractTreeBuilder.this.getUi().queueUpdate(element, updateStructure).notify(result);
            }
        });
        return result;
    }

    public void buildNodeForElement(Object element) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().buildNodeForElement(element);
    }

    public DefaultMutableTreeNode getNodeForElement(Object element) {
        if (this.isDisposed()) {
            return null;
        }
        return this.getUi().getNodeForElement(element, false);
    }

    public void cleanUp() {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().doCleanUp();
    }

    protected ProgressIndicator createProgressIndicator() {
        return null;
    }

    protected void expandNodeChildren(DefaultMutableTreeNode node) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().doExpandNodeChildren(node);
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return !this.isDisposed() && this.getRootElement() == this.getTreeStructureElement(nodeDescriptor);
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor descriptor) {
        return false;
    }

    protected boolean isSmartExpand() {
        return true;
    }

    public final boolean isDisposed() {
        return this.getUi() == null || this.getUi().isReleaseRequested();
    }

    public final void updateSubtree(DefaultMutableTreeNode node) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().updateSubtree(node, true);
    }

    public final boolean wasRootNodeInitialized() {
        return !this.isDisposed() && this.getUi().wasRootNodeInitialized();
    }

    public final boolean isNodeBeingBuilt(TreePath path) {
        return !this.isDisposed() && this.getUi().isNodeBeingBuilt(path);
    }

    public final void buildNodeForPath(Object[] path) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().buildNodeForPath(path);
    }

    public final DefaultMutableTreeNode getNodeForPath(Object[] path) {
        if (this.isDisposed()) {
            return null;
        }
        return this.getUi().getNodeForPath(path);
    }

    protected Object findNodeByElement(Object element) {
        if (this.isDisposed()) {
            return null;
        }
        return this.getUi().findNodeByElement(element);
    }

    public static boolean isLoadingNode(DefaultMutableTreeNode node) {
        return AbstractTreeUi.isLoadingNode(node);
    }

    public boolean isChildrenResortingNeeded(NodeDescriptor descriptor) {
        return true;
    }

    protected void runOnYeildingDone(Runnable onDone) {
        if (this.isDisposed()) {
            return;
        }
        if (this.myUi.isPassthroughMode() || SwingUtilities.isEventDispatchThread()) {
            onDone.run();
        } else {
            this.myLaterInvocator.offer((Object)onDone);
        }
    }

    protected void yield(Runnable runnable) {
        if (this.isDisposed()) {
            return;
        }
        if (this.myUi.isPassthroughMode()) {
            runnable.run();
        } else {
            this.myLaterInvocator.offer((Object)runnable);
        }
    }

    public boolean isToYieldUpdateFor(DefaultMutableTreeNode node) {
        return true;
    }

    public boolean isToEnsureSelectionOnFocusGained() {
        return true;
    }

    protected void runBackgroundLoading(final Runnable runnable) {
        if (this.isDisposed()) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app != null) {
            app.runReadAction(new TreeRunnable("AbstractTreeBuilder.runBackgroundLoading"){

                @Override
                public void perform() {
                    runnable.run();
                }
            });
        } else {
            runnable.run();
        }
    }

    protected void updateAfterLoadedInBackground(Runnable runnable) {
        if (this.isDisposed()) {
            return;
        }
        if (this.myUi.isPassthroughMode()) {
            runnable.run();
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        }
    }

    @Deprecated
    public final ActionCallback getIntialized() {
        return this.getInitialized();
    }

    public final ActionCallback getInitialized() {
        if (this.isDisposed()) {
            return new ActionCallback.Rejected();
        }
        return this.myUi.getInitialized();
    }

    public final ActionCallback getReady(Object requestor) {
        if (this.isDisposed()) {
            return new ActionCallback.Rejected();
        }
        return this.myUi.getReady(requestor);
    }

    protected void sortChildren(Comparator<TreeNode> nodeComparator, DefaultMutableTreeNode node, ArrayList<TreeNode> children) {
        Collections.sort(children, nodeComparator);
    }

    public void setPassthroughMode(boolean passthrough) {
        if (this.isDisposed()) {
            return;
        }
        this.myUi.setPassthroughMode(passthrough);
    }

    public void expandAll(Runnable onDone) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().expandAll(onDone);
    }

    public ActionCallback cancelUpdate() {
        if (this.isDisposed()) {
            return new ActionCallback.Rejected();
        }
        return this.getUi().cancelUpdate();
    }

    public ActionCallback batch(Progressive progressive) {
        if (this.isDisposed()) {
            return new ActionCallback.Rejected();
        }
        return this.getUi().batch(progressive);
    }

    public AsyncResult<Object> revalidateElement(Object element) {
        if (this.isDisposed()) {
            return new AsyncResult.Rejected<Object>();
        }
        AbstractTreeStructure structure = this.getTreeStructure();
        if (structure == null) {
            return new AsyncResult.Rejected<Object>();
        }
        return structure.revalidateElement(element);
    }

    public final AbstractTreeUi getUi() {
        return this.myUi;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.myUi.requestRelease();
    }

    void releaseUi() {
        this.myUi = null;
    }

    protected boolean updateNodeDescriptor(NodeDescriptor descriptor) {
        if (this.isDisposed()) {
            return false;
        }
        AbstractTreeUi ui = this.getUi();
        return ui != null && descriptor.update();
    }

    public final DefaultTreeModel getTreeModel() {
        if (this.isDisposed()) {
            return null;
        }
        JTree tree = this.getTree();
        return tree == null ? null : (DefaultTreeModel)tree.getModel();
    }

    public final Set<Object> getSelectedElements() {
        if (this.isDisposed()) {
            return Collections.emptySet();
        }
        return this.getUi().getSelectedElements();
    }

    public final <T> Set<T> getSelectedElements(Class<T> elementClass) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (Object o : this.getSelectedElements()) {
            Object each = this.transformElement(o);
            if (!elementClass.isInstance(each)) continue;
            result.add(each);
        }
        return result;
    }

    protected Object transformElement(Object object) {
        return object;
    }

    public final void setCanYieldUpdate(boolean yield) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().setCanYield(yield);
    }

    public static AbstractTreeBuilder getBuilderFor(JTree tree) {
        WeakReference ref = (WeakReference)tree.getClientProperty(TREE_BUILDER);
        return (AbstractTreeBuilder)SoftReference.dereference((Reference)ref);
    }

    public final <T> Object accept(Class<?> nodeClass, TreeVisitor<T> visitor) {
        return this.accept(nodeClass, this.getRootElement(), visitor);
    }

    private <T> Object accept(Class<?> nodeClass, Object element, TreeVisitor<T> visitor) {
        Object[] children;
        if (element == null) {
            return null;
        }
        if (nodeClass.isAssignableFrom(element.getClass()) && visitor.visit(element)) {
            return element;
        }
        for (Object each : children = this.getTreeStructure().getChildElements(element)) {
            Object childObject = this.accept(nodeClass, each, visitor);
            if (childObject == null) continue;
            return childObject;
        }
        return null;
    }

    public <T> boolean select(Class nodeClass, TreeVisitor<T> visitor, Runnable onDone, boolean addToSelection) {
        Object element = this.accept(nodeClass, visitor);
        if (element != null) {
            this.select(element, onDone, addToSelection);
            return true;
        }
        return false;
    }

    public void scrollSelectionToVisible(Runnable onDone, boolean shouldBeCentered) {
        if (this.isDisposed()) {
            return;
        }
        this.myUi.scrollSelectionToVisible(onDone, shouldBeCentered);
    }

    private static boolean isUnitTestingMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    public static boolean isToPaintSelection(JTree tree) {
        AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(tree);
        return builder == null || builder.getUi() == null || builder.getUi().isToPaintSelection();
    }

    public boolean isSelectionBeingAdjusted() {
        AbstractTreeUi ui = this.getUi();
        return ui != null && ui.isSelectionBeingAdjusted();
    }

    class UserRunnable
    implements Runnable {
        private final Runnable myRunnable;

        public UserRunnable(Runnable runnable) {
            this.myRunnable = runnable;
        }

        @Override
        public void run() {
            if (this.myRunnable != null) {
                AbstractTreeUi ui = AbstractTreeBuilder.this.getUi();
                if (ui != null) {
                    ui.executeUserRunnable(this.myRunnable);
                } else {
                    this.myRunnable.run();
                }
            }
        }
    }

    public static class AbstractTreeNodeWrapper
    extends AbstractTreeNode<Object> {
        public AbstractTreeNodeWrapper() {
            super((Project)null, null);
        }

        @Override
        public Collection<AbstractTreeNode> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public void update(PresentationData presentation) {
        }
    }
}

