/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.NodeDescriptor;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;

public class TreeUpdatePass {
    private final DefaultMutableTreeNode myNode;
    private long myUpdateStamp;
    private boolean myExpired;
    private DefaultMutableTreeNode myCurrentNode;
    private final long myAllocation;
    private boolean myUpdateChildren = true;
    private boolean myUpdateStructure = true;
    private final Set<NodeDescriptor> myUpdatedDescriptors = new HashSet<NodeDescriptor>();

    public TreeUpdatePass(DefaultMutableTreeNode node) {
        this.myNode = node;
        this.myAllocation = System.currentTimeMillis();
    }

    public TreeUpdatePass setUpdateChildren(boolean updateChildren) {
        this.myUpdateChildren = updateChildren;
        return this;
    }

    public boolean isUpdateChildren() {
        return this.myUpdateChildren;
    }

    public DefaultMutableTreeNode getNode() {
        return this.myNode;
    }

    public TreeUpdatePass setUpdateStamp(long updateCount) {
        this.myUpdateStamp = updateCount;
        return this;
    }

    public long getUpdateStamp() {
        return this.myUpdateStamp;
    }

    public void expire() {
        this.myExpired = true;
    }

    public boolean isExpired() {
        return this.myExpired;
    }

    public DefaultMutableTreeNode getCurrentNode() {
        return this.myCurrentNode;
    }

    public void setCurrentNode(DefaultMutableTreeNode currentNode) {
        this.myCurrentNode = currentNode;
    }

    @NonNls
    public String toString() {
        return "TreeUpdatePass node=" + this.myNode + " structure=" + this.myUpdateStructure + " stamp=" + this.myUpdateStamp + " expired=" + this.myExpired + " currentNode=" + this.myCurrentNode + " allocation=" + this.myAllocation;
    }

    public boolean willUpdate(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode currentNode = this.myCurrentNode != null ? this.myCurrentNode : this.myNode;
        return node.isNodeAncestor(currentNode);
    }

    public TreeUpdatePass setUpdateStructure(boolean update) {
        this.myUpdateStructure = update;
        return this;
    }

    public boolean isUpdateStructure() {
        return this.myUpdateStructure;
    }

    public void addToUpdated(NodeDescriptor nodeDescriptor) {
        this.myUpdatedDescriptors.add(nodeDescriptor);
    }

    public boolean isUpdated(NodeDescriptor descriptor) {
        return this.myUpdatedDescriptors.contains(descriptor);
    }
}

