/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.SorterUtil;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;

public interface Sorter
extends TreeAction {
    public static final Sorter[] EMPTY_ARRAY = new Sorter[0];
    @NonNls
    public static final String ALPHA_SORTER_ID = "ALPHA_COMPARATOR";
    public static final Sorter ALPHA_SORTER = new Sorter(){

        @Override
        public Comparator getComparator() {
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s1 = SorterUtil.getStringPresentation(o1);
                    String s2 = SorterUtil.getStringPresentation(o2);
                    return s1.compareToIgnoreCase(s2);
                }
            };
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public ActionPresentation getPresentation() {
            return new ActionPresentationData(IdeBundle.message("action.sort.alphabetically", new Object[0]), IdeBundle.message("action.sort.alphabetically", new Object[0]), AllIcons.ObjectBrowser.Sorted);
        }

        @Override
        public String getName() {
            return Sorter.ALPHA_SORTER_ID;
        }
    };

    public Comparator getComparator();

    public boolean isVisible();
}

