/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.wizard;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.ide.wizard.StepListener;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;

public abstract class AbstractWizard<T extends Step>
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.wizard.AbstractWizard");
    protected int myCurrentStep;
    protected final ArrayList<T> mySteps;
    private JButton myPreviousButton;
    private JButton myNextButton;
    private JButton myCancelButton;
    private JButton myHelpButton;
    protected JPanel myContentPanel;
    protected TallImageComponent myIcon;
    private Component myCurrentStepComponent;
    private final Map<Component, String> myComponentToIdMap = new HashMap<Component, String>();
    private final StepListener myStepListener = new StepListener(){

        @Override
        public void stateChanged() {
            AbstractWizard.this.updateStep();
        }
    };

    public AbstractWizard(String title, Component dialogParent) {
        super(dialogParent, true);
        this.mySteps = new ArrayList();
        this.initWizard(title);
    }

    public AbstractWizard(String title, Project project) {
        super(project, true);
        this.mySteps = new ArrayList();
        this.initWizard(title);
    }

    private void initWizard(String title) {
        this.setTitle(title);
        this.myCurrentStep = 0;
        this.myPreviousButton = new JButton(IdeBundle.message("button.wizard.previous", new Object[0]));
        this.myNextButton = new JButton(IdeBundle.message("button.wizard.next", new Object[0]));
        this.myCancelButton = new JButton(CommonBundle.getCancelButtonText());
        this.myHelpButton = new JButton(CommonBundle.getHelpButtonText());
        this.myContentPanel = new JPanel(new JBCardLayout());
        this.myIcon = new TallImageComponent(null);
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            rootPane.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractWizard.this.helpAction();
                }
            }, KeyStroke.getKeyStroke(112, 0), 2);
            rootPane.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractWizard.this.helpAction();
                }
            }, KeyStroke.getKeyStroke(156, 0), 2);
        }
    }

    @Override
    protected JComponent createSouthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        JPanel buttonPanel = new JPanel();
        if (SystemInfo.isMac) {
            panel.add((Component)buttonPanel, "East");
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            if (!UIUtil.isUnderDarcula()) {
                this.myHelpButton.putClientProperty("JButton.buttonType", "help");
            }
            if (UIUtil.isUnderAquaLookAndFeel()) {
                this.myHelpButton.setText("");
            }
            JPanel leftPanel = new JPanel();
            if (ApplicationInfo.contextHelpAvailable()) {
                leftPanel.add(this.myHelpButton);
            }
            leftPanel.add(this.myCancelButton);
            panel.add((Component)leftPanel, "West");
            if (this.mySteps.size() > 1) {
                buttonPanel.add(Box.createHorizontalStrut(5));
                buttonPanel.add(this.myPreviousButton);
            }
            buttonPanel.add(Box.createHorizontalStrut(5));
            buttonPanel.add(this.myNextButton);
        } else {
            panel.add((Component)buttonPanel, "Center");
            GroupLayout layout = new GroupLayout(buttonPanel);
            buttonPanel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
            GroupLayout.ParallelGroup vGroup = layout.createParallelGroup();
            ArrayList buttons = ContainerUtil.newArrayListWithCapacity((int)5);
            boolean helpAvailable = ApplicationInfo.contextHelpAvailable();
            if (helpAvailable && UIUtil.isUnderGTKLookAndFeel()) {
                AbstractWizard.add(hGroup, vGroup, buttons, this.myHelpButton);
            }
            AbstractWizard.add(hGroup, vGroup, null, Box.createHorizontalGlue());
            if (this.mySteps.size() > 1) {
                AbstractWizard.add(hGroup, vGroup, buttons, this.myPreviousButton);
            }
            AbstractWizard.add(hGroup, vGroup, buttons, this.myNextButton, this.myCancelButton);
            if (helpAvailable && !UIUtil.isUnderGTKLookAndFeel()) {
                AbstractWizard.add(hGroup, vGroup, buttons, this.myHelpButton);
            }
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
            layout.linkSize(buttons.toArray(new Component[buttons.size()]));
        }
        this.myPreviousButton.setEnabled(false);
        this.myPreviousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.doPreviousAction();
            }
        });
        this.myNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractWizard.this.isLastStep()) {
                    Step currentStep = (Step)AbstractWizard.this.mySteps.get(AbstractWizard.this.myCurrentStep);
                    LOG.assertTrue(currentStep != null);
                    try {
                        currentStep._commit(true);
                        AbstractWizard.this.doOKAction();
                    }
                    catch (CommitStepException exc) {
                        String message = exc.getMessage();
                        if (message != null) {
                            Messages.showErrorDialog(AbstractWizard.this.myContentPanel, message);
                        }
                    }
                } else {
                    AbstractWizard.this.doNextAction();
                }
            }
        });
        this.myCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.doCancelAction();
            }
        });
        this.myHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.helpAction();
            }
        });
        return panel;
    }

    private static void add(GroupLayout.Group hGroup, GroupLayout.Group vGroup, Collection<Component> collection, Component ... components) {
        for (Component component : components) {
            hGroup.addComponent(component);
            vGroup.addComponent(component);
            if (collection == null) continue;
            collection.add(component);
        }
    }

    @Override
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myContentPanel, "Center");
        panel.add((Component)this.myIcon, "West");
        return panel;
    }

    public int getCurrentStep() {
        return this.myCurrentStep;
    }

    public int getStepCount() {
        return this.mySteps.size();
    }

    public T getCurrentStepObject() {
        return (T)((Step)this.mySteps.get(this.myCurrentStep));
    }

    public void addStep(T step) {
        this.addStep(step, this.mySteps.size());
    }

    public void addStep(T step, int index) {
        JComponent component;
        this.mySteps.add(index, step);
        if (step instanceof StepAdapter) {
            ((StepAdapter)step).registerStepListener(this.myStepListener);
        }
        if ((component = step.getComponent()) != null) {
            this.addStepComponent(component);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.updateStep();
    }

    protected String addStepComponent(Component component) {
        String id = this.myComponentToIdMap.get(component);
        if (id == null) {
            id = Integer.toString(this.myComponentToIdMap.size());
            this.myComponentToIdMap.put(component, id);
            this.myContentPanel.add(component, id);
        }
        return id;
    }

    private void showStepComponent(Component component) {
        String id = this.myComponentToIdMap.get(component);
        if (id == null) {
            id = this.addStepComponent(component);
            this.myContentPanel.revalidate();
            this.myContentPanel.repaint();
        }
        ((JBCardLayout)this.myContentPanel.getLayout()).swipe(this.myContentPanel, id, JBCardLayout.SwipeDirection.AUTO);
    }

    protected void doPreviousAction() {
        Step currentStep = (Step)this.mySteps.get(this.myCurrentStep);
        LOG.assertTrue(currentStep != null);
        try {
            currentStep._commit(false);
        }
        catch (CommitStepException exc) {
            Messages.showErrorDialog(this.myContentPanel, exc.getMessage());
            return;
        }
        this.myCurrentStep = this.getPreviousStep(this.myCurrentStep);
        this.updateStep();
    }

    protected void doNextAction() {
        Step currentStep = (Step)this.mySteps.get(this.myCurrentStep);
        LOG.assertTrue(currentStep != null);
        LOG.assertTrue(!this.isLastStep(), (Object)("steps: " + this.mySteps + " current: " + currentStep));
        try {
            currentStep._commit(false);
        }
        catch (CommitStepException exc) {
            Messages.showErrorDialog(this.myContentPanel, exc.getMessage());
            return;
        }
        this.myCurrentStep = this.getNextStep(this.myCurrentStep);
        this.updateStep();
    }

    protected int getNextStep(int step) {
        int stepCount = this.mySteps.size();
        if (++step >= stepCount) {
            step = stepCount - 1;
        }
        return step;
    }

    protected final int getNextStep() {
        return this.getNextStep(this.getCurrentStep());
    }

    protected T getNextStepObject() {
        int step = this.getNextStep();
        return (T)((Step)this.mySteps.get(step));
    }

    protected int getPreviousStep(int step) {
        if (--step < 0) {
            step = 0;
        }
        return step;
    }

    protected final int getPreviousStep() {
        return this.getPreviousStep(this.getCurrentStep());
    }

    protected void updateStep() {
        if (this.mySteps.isEmpty()) {
            return;
        }
        Step step = (Step)this.mySteps.get(this.myCurrentStep);
        LOG.assertTrue(step != null);
        step._init();
        this.myCurrentStepComponent = step.getComponent();
        LOG.assertTrue(this.myCurrentStepComponent != null);
        this.showStepComponent(this.myCurrentStepComponent);
        Icon icon = step.getIcon();
        if (icon != null) {
            this.myIcon.setIcon(icon);
            this.myIcon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        }
        this.updateButtons();
        JComponent component = ((Step)this.mySteps.get(this.getCurrentStep())).getPreferredFocusedComponent();
        AbstractWizard.requestFocusTo(component != null ? component : this.myNextButton);
    }

    private static void requestFocusTo(final JComponent component) {
        UiNotifyConnector.doWhenFirstShown(component, new Runnable(){

            @Override
            public void run() {
                IdeFocusManager focusManager = IdeFocusManager.findInstanceByComponent(component);
                focusManager.requestFocus(component, false);
            }
        });
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        JComponent component = this.getCurrentStepObject().getPreferredFocusedComponent();
        return component == null ? super.getPreferredFocusedComponent() : component;
    }

    protected boolean canGoNext() {
        return true;
    }

    protected boolean canFinish() {
        return this.isLastStep() && this.canGoNext();
    }

    protected void updateButtons() {
        if (this.isLastStep()) {
            if (this.mySteps.size() > 1) {
                this.myNextButton.setText(UIUtil.removeMnemonic((String)IdeBundle.message("button.finish", new Object[0])));
                this.myNextButton.setMnemonic('F');
            } else {
                this.myNextButton.setText(IdeBundle.message("button.ok", new Object[0]));
            }
            this.myNextButton.setEnabled(this.canFinish());
        } else {
            this.myNextButton.setText(UIUtil.removeMnemonic((String)IdeBundle.message("button.wizard.next", new Object[0])));
            this.myNextButton.setMnemonic('N');
            this.myNextButton.setEnabled(this.canGoNext());
        }
        if (this.myNextButton.isEnabled() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.getRootPane().setDefaultButton(this.myNextButton);
        }
        this.myPreviousButton.setEnabled(this.myCurrentStep > 0);
    }

    protected boolean isLastStep() {
        return this.myCurrentStep == this.mySteps.size() - 1 || this.getCurrentStep() == this.getNextStep(this.getCurrentStep());
    }

    protected JButton getNextButton() {
        return this.myNextButton;
    }

    protected JButton getPreviousButton() {
        return this.myPreviousButton;
    }

    protected JButton getHelpButton() {
        return this.myHelpButton;
    }

    public JButton getCancelButton() {
        return this.myCancelButton;
    }

    @Deprecated
    protected JButton getFinishButton() {
        return new JButton();
    }

    public Component getCurrentStepComponent() {
        return this.myCurrentStepComponent;
    }

    protected void helpAction() {
        HelpManager.getInstance().invokeHelp(this.getHelpID());
    }

    @Override
    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.getHelpID());
    }

    protected int getNumberOfSteps() {
        return this.mySteps.size();
    }

    @NonNls
    protected abstract String getHelpID();

    public static class TallImageComponent
    extends OpaquePanel {
        private Icon myIcon;

        private TallImageComponent(Icon icon) {
            this.myIcon = icon;
        }

        @Override
        protected void paintChildren(Graphics g) {
            if (this.myIcon == null) {
                return;
            }
            this.paintIcon(g);
        }

        public void paintIcon(Graphics g) {
            if (this.myIcon == null) {
                return;
            }
            BufferedImage image = UIUtil.createImage((int)this.myIcon.getIconWidth(), (int)this.myIcon.getIconHeight(), (int)2);
            Graphics2D gg = image.createGraphics();
            this.myIcon.paintIcon(this, gg, 0, 0);
            Rectangle bounds = g.getClipBounds();
            for (int y = this.myIcon.getIconHeight() - 1; y < bounds.y + bounds.height; ++y) {
                g.drawImage(image, bounds.x, y, bounds.x + bounds.width, y + 1, 0, this.myIcon.getIconHeight() - 1, bounds.width, this.myIcon.getIconHeight(), this);
            }
            g.drawImage(image, 0, 0, this);
        }

        public void setIcon(Icon icon) {
            this.myIcon = icon;
            this.revalidate();
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.myIcon != null ? this.myIcon.getIconWidth() : 0, 0);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(this.myIcon != null ? this.myIcon.getIconWidth() : 0, 0);
        }
    }
}

